% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CostMethods.R
\docType{methods}
\name{Cost-Methods}
\alias{Cost-Methods}
\alias{calcMC}
\alias{calcMC,ANY-method}
\alias{calcMC,Bertrand-method}
\alias{calcMC,VertBargBertLogit-method}
\alias{calcMC,Auction2ndLogit-method}
\alias{calcMC,Cournot-method}
\alias{calcMC,Auction2ndCap-method}
\alias{calcdMC}
\alias{calcdMC,ANY-method}
\alias{calcdMC,Stackelberg-method}
\alias{calcVC}
\alias{calcVC,ANY-method}
\alias{calcVC,Cournot-method}
\title{Methods for Calculating marginal and Variable Costs}
\usage{
\S4method{calcMC}{Bertrand}(object, preMerger = TRUE)

\S4method{calcMC}{VertBargBertLogit}(object, preMerger = TRUE)

\S4method{calcMC}{Auction2ndCap}(object, t, preMerger = TRUE,
  exAnte = TRUE)

\S4method{calcMC}{Cournot}(object, preMerger = TRUE)

\S4method{calcMC}{Auction2ndLogit}(object, preMerger = TRUE,
  exAnte = FALSE)

\S4method{calcdMC}{Stackelberg}(object, preMerger = TRUE)

\S4method{calcVC}{Cournot}(object, preMerger = TRUE)
}
\arguments{
\item{object}{An instance of the respective class (see description for the classes)}

\item{preMerger}{If TRUE, the pre-merger ownership structure is used. If FALSE, the post-merger ownership structure is used.
Default is TRUE.}

\item{t}{The capacity profile of each supplier. Default is \sQuote{preMerger} capacities.}

\item{exAnte}{If \sQuote{exAnte} equals TRUE then the
\emph{ex ante} expected result for each firm is produced, while FALSE produces the
expected result conditional on each firm winning the auction. Default is FALSE.}
}
\description{
For Auction2ndCap, calcMC calculates (constant) marginal cost for each
product. For those classes that do not require prices, returns a
length-k vector of NAs when prices are not supplied.

For Bertrand, calcMC computes either pre- or post-merger marginal costs. Marginal costs
are assumed to be constant. Post-merger marginal costs are equal to
pre-merger marginal costs multiplied by 1+\sQuote{mcDelta}, a length-k
vector of marginal cost changes. \sQuote{mcDelta} will typically be between 0 and 1.

For Auction2ndLogit, calcMC computes constant marginal costs impied by the model.

For Cournot, calcMC calculates marginal cost for each product.

calcdMC computes the derivative of either pre- or post-merger marginal costs. The derivative of Marginal costs
is assumed to be constant. Post-merger marginal costs are equal to
pre-merger marginal costs multiplied by 1+\sQuote{mcDelta}, a length-k
vector of marginal cost changes. \sQuote{mcDelta} will typically be between 0 and 1.

calcVC computes either pre- or post-merger variable costs. Variable costs
are assumed to be quadratic by default. Post-merger variable costs are equal to
pre-merger variable costs multiplied by 1+\sQuote{mcDelta}, a length-k
vector of marginal cost changes. \sQuote{mcDelta} will typically be between 0
and 1.
}
\keyword{methods}
