% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OutputMethods.R
\docType{methods}
\name{Output-Methods}
\alias{Output-Methods}
\alias{calcQuantities}
\alias{calcQuantities,ANY-method}
\alias{calcQuantities,Logit-method}
\alias{calcQuantities,CES-method}
\alias{calcQuantities,Linear-method}
\alias{calcQuantities,LogLin-method}
\alias{calcQuantities,LogitCap-method}
\alias{calcQuantities,Cournot-method}
\alias{calcQuantities,Stackelberg-method}
\alias{calcQuantities,AIDS-method}
\alias{calcShares}
\alias{calcShares,ANY-method}
\alias{calcShares,AIDS-method}
\alias{calcShares,CES-method}
\alias{calcShares,CESNests-method}
\alias{calcShares,Linear-method}
\alias{calcShares,Logit-method}
\alias{calcShares,LogitNests-method}
\alias{calcShares,Auction2ndLogit-method}
\alias{calcShares,Cournot-method}
\alias{calcRevenues}
\alias{calcRevenues,ANY-method}
\alias{calcRevenues,Bertrand-method}
\alias{calcRevenues,CES-method}
\alias{calcRevenues,AIDS-method}
\alias{calcRevenues,Cournot-method}
\alias{calcShares,Auction2ndCap-method}
\alias{calcShares,VertBargBertLogit-method}
\title{Output Methods}
\usage{
\S4method{calcQuantities}{Cournot}(object, preMerger = TRUE,
  market = FALSE, ...)

\S4method{calcQuantities}{Stackelberg}(object, preMerger = TRUE,
  market = FALSE, ...)

\S4method{calcQuantities}{Linear}(object, preMerger = TRUE,
  market = FALSE)

\S4method{calcQuantities}{Logit}(object, preMerger = TRUE,
  market = FALSE)

\S4method{calcQuantities}{LogLin}(object, preMerger = TRUE,
  market = FALSE, ...)

\S4method{calcQuantities}{AIDS}(object, preMerger = TRUE,
  market = FALSE)

\S4method{calcQuantities}{CES}(object, preMerger = TRUE,
  market = FALSE)

\S4method{calcRevenues}{Bertrand}(object, preMerger = TRUE,
  market = FALSE)

\S4method{calcRevenues}{Cournot}(object, preMerger = TRUE,
  market = FALSE)

\S4method{calcQuantities}{AIDS}(object, preMerger = TRUE,
  market = FALSE)

\S4method{calcRevenues}{CES}(object, preMerger = TRUE, market = FALSE)

\S4method{calcShares}{Auction2ndCap}(object, preMerger = TRUE,
  exAnte = TRUE)

\S4method{calcShares}{Cournot}(object, preMerger = TRUE,
  revenue = FALSE)

\S4method{calcShares}{Linear}(object, preMerger = TRUE,
  revenue = FALSE)

\S4method{calcShares}{VertBargBertLogit}(object, preMerger = TRUE,
  revenue = FALSE)

\S4method{calcShares}{Logit}(object, preMerger = TRUE, revenue = FALSE)

\S4method{calcShares}{AIDS}(object, preMerger = TRUE, revenue = TRUE)

\S4method{calcShares}{LogitNests}(object, preMerger = TRUE,
  revenue = FALSE)

\S4method{calcShares}{Auction2ndLogit}(object, preMerger = TRUE,
  revenue = FALSE, subset)

\S4method{calcShares}{CES}(object, preMerger = TRUE, revenue = FALSE)

\S4method{calcShares}{CESNests}(object, preMerger = TRUE,
  revenue = FALSE)
}
\arguments{
\item{object}{An instance of one of the classes listed above.}

\item{preMerger}{If TRUE, returns pre-merger outcome. If
FALSE, returns post-merger outcome.  Default is TRUE.}

\item{market}{If TRUE, reports market-level summary.
Otherwise reports product/plant level summary. Default is FALSE.}

\item{...}{Additional arguments to pass to \code{calcQuantities}.}

\item{exAnte}{If \sQuote{exAnte} equals TRUE then the
\emph{ex ante} expected result for each firm is produced, while FALSE produces the
expected result conditional on each firm winning the auction. Default is FALSE.}

\item{revenue}{If TRUE, returns revenues. If FALSE,
returns quantities. Default is TRUE.}

\item{subset}{A vector of length k where each element equals TRUE if
the product indexed by that element should be included in the
post-merger simulation and FALSE if it should be excluded. Default is a
length k vector of TRUE.}
}
\description{
This section contains three types of methods: calcShares, calcQuantities, and calcRevenues.
 calcShares computes equilibrium product shares assuming that firms are playing a
 Nash-Bertrand or Cournot  game. \sQuote{revenue} takes
 on a value of TRUE or FALSE, where TRUE calculates revenue shares,
 while FALSE calculates quantity shares.

 calcQuantities computes equilibrium product quantities assuming that firms are playing a
 Nash-Bertrand, 2nd Score Auction, or Cournot game. Setting `market' to TRUE returns total market quantity.

 calcRevenues computes equilibrium product revenues assuming that firms are playing a
 Nash-Bertrand, 2nd Score Auction, or Cournot game. Setting `market' to TRUE returns total market revenue.
}
\keyword{methods}
