% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PSMethods.R
\docType{methods}
\name{PS-methods}
\alias{PS-methods}
\alias{calcProducerSurplus}
\alias{calcProducerSurplus,ANY-method}
\alias{calcProducerSurplus,Bertrand-method}
\alias{calcProducerSurplus,Cournot-method}
\alias{calcProducerSurplusGrimTrigger}
\alias{calcProducerSurplus,Auction2ndCap-method}
\alias{calcProducerSurplusGrimTrigger,Bertrand-method}
\title{Producer Surplus Methods}
\usage{
\S4method{calcProducerSurplus}{Bertrand}(object, preMerger = TRUE)

\S4method{calcProducerSurplus}{Auction2ndCap}(object, preMerger = TRUE,
  exAnte = TRUE)

\S4method{calcProducerSurplus}{Cournot}(object, preMerger = TRUE)

\S4method{calcProducerSurplusGrimTrigger}{Bertrand}(object, coalition,
  discount, preMerger = TRUE, isCollusion = FALSE, ...)
}
\arguments{
\item{object}{An instance of one of the classes listed above.}

\item{preMerger}{If TRUE, returns pre-merger outcome. If FALSE, returns post-merger outcome. Default is TRUE.}

\item{exAnte}{If \sQuote{exAnte} equals TRUE then the
\emph{ex ante} expected result for each firm is produced, while FALSE produces the
expected result conditional on each firm winning the auction. Default is TRUE.}

\item{coalition}{A length c vector of integers indicating the index of the products participating in the coalition.}

\item{discount}{A length k vector of values between 0 and 1 that
represent the product-specific discount rate for all products
produced by firms particiapting in the coalition. NAs are allowed.}

\item{isCollusion}{TRUE recalculates demand and cost parameters under
the assumption that the coalition specified in \sQuote{coalition} is
operating pre-merger. FALSE (the default) uses demand
and cost parameters calculated from the \sQuote{ownerPre} matrix.}

\item{...}{Additional argument to pass to calcPrices (for \code{calcProducerSurplusGrimTrigger})}
}
\value{
\code{calcProducerSurplusGrimTrigger} returns a data frame with rows
equal to the number of products produced by any firm participating in
the coalition and the following 5 columns

\itemize{
    \item{Discount:}{The user-supplied discount rate}
    \item{Coord:}{Single period producer surplus from coordinating}
    \item{Defect:}{Single period producer surplus from defecting}
    \item{Punish:}{Single period producer surplus from punishing using Bertrand price}
    \item{IC:}{TRUE if the discounted producer surplus from coordinating across all firm products are
    greater than the surplus from defecting across all firm products for one period and receiving
    discounted Bertrand surplus for all subsequent periods under Grim Trigger.}
}
}
\description{
In the following methods, \code{calcProducerSurplus} computes the expected profits of each supplier
with the game depending on the class. The available classes are: Bertrand, Cournot, and Auction2ndCap.

\code{calcProducerSurplusGrimTrigger} is a method that
may be used to explore how a merger affects firms' incentives to collude.
}
\details{
calcProducerSurplusGrimTrigger calculates \sQuote{preMerger} product
producer surplus (as well as other statistics -- see below), under the
assumption that firms are playing an N-player iterated Prisoner's Dilemma where in each period a
coalition of firms decides whether to \emph{cooperate} with
one another by setting the joint surplus maximizing price on some
\sQuote{coalition} of their products, or \emph{defect} from the coalition by setting all of their products'
prices to optimally undercut the prices of the coalition's products. Moreover, firms are assumed
to play Grim Trigger strategies where each firm cooperates in the
current period so long as \emph{every} firm in the coalition cooperated last period and
defects otherwise. product level \sQuote{discount} rates are then employed to determine
whether a firm's discounted surplus from remaining in the coalition are greater than
its surplus from optimally undercutting the coalition prices' for one
period plus its discounted surplus when all firms set Nash-Bertrand prices in all subsequent periods.
}
\keyword{methods}
