% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/procedure.R
\name{Procedure}
\alias{Procedure}
\title{Procedure Object}
\description{
This object specifies alternating optimization procedure.
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{npar}}{(\code{integer(1)})\cr
The length of the target argument.}

\item{\code{partition}}{(\code{character(1)} or \code{list()})\cr
Defines the parameter partition, and can be either
\itemize{
\item \code{"sequential"} for treating each parameter separately,
\item \code{"random"} for a random partition in each iteration,
\item \code{"none"} for no partition (which is equivalent to joint optimization),
\item or a \code{list} of vectors of parameter indices, specifying a custom
partition for the alternating optimization process.
}}

\item{\code{new_block_probability}}{(\code{numeric(1)})\cr
Only relevant if \code{partition = "random"}.
The probability for a new parameter block when creating a random
partitions.
Values close to 0 result in larger parameter blocks, values close to 1
result in smaller parameter blocks.}

\item{\code{minimum_block_number}}{(\code{integer(1)})\cr
Only relevant if \code{partition = "random"}.
The minimum number of blocks in random partitions.}

\item{\code{verbose}}{(\code{logical(1)})\cr
Whether to print tracing details during the alternating optimization
process.}

\item{\code{minimize}}{(\code{logical(1)})\cr
Whether to minimize during the alternating optimization process.
If \code{FALSE}, maximization is performed.}

\item{\code{iteration_limit}}{(\code{integer(1)} or \code{Inf})\cr
The maximum number of iterations through the parameter partition before
the alternating optimization process is terminated.
Can also be \code{Inf} for no iteration limit.}

\item{\code{seconds_limit}}{(\code{numeric(1)})\cr
The time limit in seconds before the alternating optimization process is
terminated.
Can also be \code{Inf} for no time limit.
Note that this stopping criteria is only checked \emph{after}
a sub-problem is solved and not \emph{within} solving a sub-problem, so the
actual process time can exceed this limit.}

\item{\code{tolerance_value}}{(\code{numeric(1)})\cr
A non-negative tolerance value. The alternating optimization terminates
if the absolute difference between the current function value and the one
from the last iteration is smaller than \code{tolerance_value}.
Can be \code{0} for no value threshold.}

\item{\code{tolerance_parameter}}{(\code{numeric(1)})\cr
A non-negative tolerance value. The alternating optimization terminates
if the distance between the current estimate and the one from the last
iteration is smaller than \code{tolerance_parameter}.
Can be \code{0} for no parameter threshold.
By default, the distance is measured using the euclidean norm, but
another norm can be specified via the \code{tolerance_parameter_norm}
field.}

\item{\code{tolerance_parameter_norm}}{(\code{function})\cr
The norm that measures the distance between the current estimate and the
one from the last iteration. If the distance is smaller than
\code{tolerance_parameter}, the procedure is terminated.
It must be of the form \code{function(x, y)} for two vector inputs
\code{x} and \code{y}, and return a single \code{numeric} value.
By default, the euclidean norm \code{function(x, y) sqrt(sum((x - y)^2))}
is used.}

\item{\code{iteration}}{(\code{integer(1)})\cr
The current iteration number.}

\item{\code{block}}{(\code{integer()})\cr
The currently active parameter block, represented as parameter indices.}

\item{\code{output}}{(\code{list()}, read-only)\cr
The output of the alternating optimization procedure, which is a
\code{list} with the following elements:
\itemize{
\item \code{estimate} is the parameter vector at termination.
\item \code{value} is the function value at termination.
\item \code{details} is a \code{data.frame} with full information about the procedure:
For each iteration (column \code{iteration}) it contains the function value
(column \code{value}), parameter values (columns starting with \code{p} followed by
the parameter index), the active parameter block (columns starting with \code{b}
followed by the parameter index, where \code{1} stands for a parameter contained
in the active parameter block and \code{0} if not), computation times in seconds
(column \code{seconds}), and a code that summarizes whether the update got
accepted (column \code{update_code}, where \code{0} stands for an accepted update,
\code{1} for a rejected update due to an error when solving the sub-problem, and
\code{2} for a rejected update because it did not improve the function value).
\item \code{seconds} is the overall computation time in seconds.
\item \code{stopping_reason} is a message why the procedure has terminated.
}}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Procedure-new}{\code{Procedure$new()}}
\item \href{#method-Procedure-print_status}{\code{Procedure$print_status()}}
\item \href{#method-Procedure-initialize_details}{\code{Procedure$initialize_details()}}
\item \href{#method-Procedure-update_details}{\code{Procedure$update_details()}}
\item \href{#method-Procedure-get_partition}{\code{Procedure$get_partition()}}
\item \href{#method-Procedure-get_details}{\code{Procedure$get_details()}}
\item \href{#method-Procedure-get_value}{\code{Procedure$get_value()}}
\item \href{#method-Procedure-get_value_latest}{\code{Procedure$get_value_latest()}}
\item \href{#method-Procedure-get_parameter}{\code{Procedure$get_parameter()}}
\item \href{#method-Procedure-get_parameter_latest}{\code{Procedure$get_parameter_latest()}}
\item \href{#method-Procedure-get_seconds}{\code{Procedure$get_seconds()}}
\item \href{#method-Procedure-get_seconds_total}{\code{Procedure$get_seconds_total()}}
\item \href{#method-Procedure-check_stopping}{\code{Procedure$check_stopping()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Procedure-new"></a>}}
\if{latex}{\out{\hypertarget{method-Procedure-new}{}}}
\subsection{Method \code{new()}}{
Creates a new object of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Procedure$new(
  npar = integer(),
  partition = "sequential",
  new_block_probability = 0.3,
  minimum_block_number = 2,
  verbose = FALSE,
  minimize = TRUE,
  iteration_limit = Inf,
  seconds_limit = Inf,
  tolerance_value = 1e-06,
  tolerance_parameter = 1e-06,
  tolerance_parameter_norm = function(x, y) sqrt(sum((x - y)^2))
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{npar}}{(\code{integer(1)})\cr
The (total) length of the target argument(s).}

\item{\code{partition}}{(\code{character(1)} or \code{list()})\cr
Defines the parameter partition, and can be either
\itemize{
\item \code{"sequential"} for treating each parameter separately,
\item \code{"random"} for a random partition in each iteration,
\item \code{"none"} for no partition (which is equivalent to joint optimization),
\item or a \code{list} of vectors of parameter indices, specifying a custom
partition for the alternating optimization process.
}}

\item{\code{new_block_probability}}{(\code{numeric(1)})\cr
Only relevant if \code{partition = "random"}.
The probability for a new parameter block when creating a random
partitions.
Values close to 0 result in larger parameter blocks, values close to 1
result in smaller parameter blocks.}

\item{\code{minimum_block_number}}{(\code{integer(1)})\cr
Only relevant if \code{partition = "random"}.
The minimum number of blocks in random partitions.}

\item{\code{verbose}}{(\code{logical(1)})\cr
Whether to print tracing details during the alternating optimization
process.}

\item{\code{minimize}}{(\code{logical(1)})\cr
Whether to minimize during the alternating optimization process.
If \code{FALSE}, maximization is performed.}

\item{\code{iteration_limit}}{(\code{integer(1)} or \code{Inf})\cr
The maximum number of iterations through the parameter partition before
the alternating optimization process is terminated.
Can also be \code{Inf} for no iteration limit.}

\item{\code{seconds_limit}}{(\code{numeric(1)})\cr
The time limit in seconds before the alternating optimization process is
terminated.
Can also be \code{Inf} for no time limit.
Note that this stopping criteria is only checked \emph{after}
a sub-problem is solved and not \emph{within} solving a sub-problem, so the
actual process time can exceed this limit.}

\item{\code{tolerance_value}}{(\code{numeric(1)})\cr
A non-negative tolerance value. The alternating optimization terminates
if the absolute difference between the current function value and the one
from the last iteration is smaller than \code{tolerance_value}.
Can be \code{0} for no value threshold.}

\item{\code{tolerance_parameter}}{(\code{numeric(1)})\cr
A non-negative tolerance value. The alternating optimization terminates
if the distance between the current estimate and the one from the last
iteration is smaller than \code{tolerance_parameter}.
Can be \code{0} for no parameter threshold.
By default, the distance is measured using the euclidean norm, but
another norm can be specified via the \code{tolerance_parameter_norm}
field.}

\item{\code{tolerance_parameter_norm}}{(\code{function})\cr
The norm that measures the distance between the current estimate and the
one from the last iteration. If the distance is smaller than
\code{tolerance_parameter}, the procedure is terminated.
It must be of the form \code{function(x, y)} for two vector inputs
\code{x} and \code{y}, and return a single \code{numeric} value.
By default, the euclidean norm \code{function(x, y) sqrt(sum((x - y)^2))}
is used.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Procedure-print_status"></a>}}
\if{latex}{\out{\hypertarget{method-Procedure-print_status}{}}}
\subsection{Method \code{print_status()}}{
Prints a status message.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Procedure$print_status(message, message_type = 8, verbose = self$verbose)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{message}}{(\code{character(1)})\cr
The status message.}

\item{\code{message_type}}{(\code{integer(1)})\cr
The type of the message, one of the following:
\itemize{
\item \code{1} for \code{cli::cli_h1()}
\item \code{2} for \code{cli::cli_h2()}
\item \code{3} for \code{cli::cli_h3()}
\item \code{4} for \code{cli::cli_alert_success()}
\item \code{5} for \code{cli::cli_alert_info()}
\item \code{6} for \code{cli::cli_alert_warning()}
\item \code{7} for \code{cli::cli_alert_danger()}
\item \code{8} for \code{cli::cat_line()}
}}

\item{\code{verbose}}{(\code{logical(1)})\cr
Whether to print tracing details during the alternating optimization
process.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Procedure-initialize_details"></a>}}
\if{latex}{\out{\hypertarget{method-Procedure-initialize_details}{}}}
\subsection{Method \code{initialize_details()}}{
Initializes the \code{details} part of the output.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Procedure$initialize_details(initial_parameter, initial_value)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{initial_parameter}}{(\code{numeric()})\cr
The starting parameter values for the procedure.}

\item{\code{initial_value}}{(\code{numeric(1)})\cr
The function value at the initial parameters.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Procedure-update_details"></a>}}
\if{latex}{\out{\hypertarget{method-Procedure-update_details}{}}}
\subsection{Method \code{update_details()}}{
Updates the \code{details} part of the output.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Procedure$update_details(
  value,
  parameter_block,
  seconds,
  error,
  block = self$block
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{value}}{(\code{numeric(1)})\cr
The updated function value.}

\item{\code{parameter_block}}{(\code{numeric()})\cr
The updated parameter values for the active parameter block.}

\item{\code{seconds}}{(\code{numeric(1)})\cr
The time in seconds for solving the sub-problem.}

\item{\code{error}}{(\code{logical(1)})\cr
Whether solving the sub-problem resulted in an error.}

\item{\code{block}}{(\code{integer()})\cr
The currently active parameter block, represented as parameter indices.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Procedure-get_partition"></a>}}
\if{latex}{\out{\hypertarget{method-Procedure-get_partition}{}}}
\subsection{Method \code{get_partition()}}{
Get a parameter partition.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Procedure$get_partition()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Procedure-get_details"></a>}}
\if{latex}{\out{\hypertarget{method-Procedure-get_details}{}}}
\subsection{Method \code{get_details()}}{
Get the \code{details} part of the output.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Procedure$get_details(
  which_iteration = NULL,
  which_block = NULL,
  which_column = c("iteration", "value", "parameter", "block", "seconds", "update_code")
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{which_iteration}}{(\code{integer()})\cr
Selects the iteration(s).
Can also be \code{NULL} to select all iterations.}

\item{\code{which_block}}{(\code{character(1)} or \code{integer()})\cr
Selects the parameter block in the partition and can be one of
\itemize{
\item \code{"first"} for the first parameter block,
\item \code{"last"} for the last parameter block,
\item an \code{integer} vector of parameter indices,
\item or \code{NULL} for all parameter blocks.
}}

\item{\code{which_column}}{(\code{character()})\cr
Selects the columns in the \code{details} part of the output and can be one or
more of \code{"iteration"}, \code{"value"}, \code{"parameter"}, \code{"block"}, \code{"seconds"},
and \code{"update_code"}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Procedure-get_value"></a>}}
\if{latex}{\out{\hypertarget{method-Procedure-get_value}{}}}
\subsection{Method \code{get_value()}}{
Get the function value in different steps of the alternating optimization
procedure.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Procedure$get_value(
  which_iteration = NULL,
  which_block = NULL,
  keep_iteration_column = FALSE,
  keep_block_columns = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{which_iteration}}{(\code{integer()})\cr
Selects the iteration(s).
Can also be \code{NULL} to select all iterations.}

\item{\code{which_block}}{(\code{character(1)} or \code{integer()})\cr
Selects the parameter block in the partition and can be one of
\itemize{
\item \code{"first"} for the first parameter block,
\item \code{"last"} for the last parameter block,
\item an \code{integer} vector of parameter indices,
\item or \code{NULL} for all parameter blocks.
}}

\item{\code{keep_iteration_column}}{(\code{logical()})\cr
Whether to keep the column containing the information about the iteration
in the output.}

\item{\code{keep_block_columns}}{(\code{logical()})\cr
Whether to keep the column containing the information about the active
parameter block in the output.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Procedure-get_value_latest"></a>}}
\if{latex}{\out{\hypertarget{method-Procedure-get_value_latest}{}}}
\subsection{Method \code{get_value_latest()}}{
Get the function value in the latest step of the alternating
optimization procedure.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Procedure$get_value_latest()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Procedure-get_parameter"></a>}}
\if{latex}{\out{\hypertarget{method-Procedure-get_parameter}{}}}
\subsection{Method \code{get_parameter()}}{
Get the parameter values in different steps of the alternating
optimization procedure.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Procedure$get_parameter(
  which_iteration = self$iteration,
  which_block = NULL,
  keep_iteration_column = FALSE,
  keep_block_columns = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{which_iteration}}{(\code{integer()})\cr
Selects the iteration(s).
Can also be \code{NULL} to select all iterations.}

\item{\code{which_block}}{(\code{character(1)} or \code{integer()})\cr
Selects the parameter block in the partition and can be one of
\itemize{
\item \code{"first"} for the first parameter block,
\item \code{"last"} for the last parameter block,
\item an \code{integer} vector of parameter indices,
\item or \code{NULL} for all parameter blocks.
}}

\item{\code{keep_iteration_column}}{(\code{logical()})\cr
Whether to keep the column containing the information about the iteration
in the output.}

\item{\code{keep_block_columns}}{(\code{logical()})\cr
Whether to keep the column containing the information about the active
parameter block in the output.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Procedure-get_parameter_latest"></a>}}
\if{latex}{\out{\hypertarget{method-Procedure-get_parameter_latest}{}}}
\subsection{Method \code{get_parameter_latest()}}{
Get the parameter value in the latest step of the alternating
optimization procedure.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Procedure$get_parameter_latest(parameter_type = "full")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{parameter_type}}{(\code{character(1)})\cr
Can be one of
\itemize{
\item \code{"full"} (default) to get the full parameter vector,
\item \code{"block"} to get the parameter values for the current block,
i.e., the parameters with the indices \code{self$block}
\item \code{"fixed"} to get the parameter values which are currently fixed,
i.e., all except for those with the indices \code{self$block}
}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Procedure-get_seconds"></a>}}
\if{latex}{\out{\hypertarget{method-Procedure-get_seconds}{}}}
\subsection{Method \code{get_seconds()}}{
Get the optimization time in seconds in different steps of the
alternating optimization procedure.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Procedure$get_seconds(
  which_iteration = NULL,
  which_block = NULL,
  keep_iteration_column = FALSE,
  keep_block_columns = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{which_iteration}}{(\code{integer()})\cr
Selects the iteration(s).
Can also be \code{NULL} to select all iterations.}

\item{\code{which_block}}{(\code{character(1)} or \code{integer()})\cr
Selects the parameter block in the partition and can be one of
\itemize{
\item \code{"first"} for the first parameter block,
\item \code{"last"} for the last parameter block,
\item an \code{integer} vector of parameter indices,
\item or \code{NULL} for all parameter blocks.
}}

\item{\code{keep_iteration_column}}{(\code{logical()})\cr
Whether to keep the column containing the information about the iteration
in the output.}

\item{\code{keep_block_columns}}{(\code{logical()})\cr
Whether to keep the column containing the information about the active
parameter block in the output.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Procedure-get_seconds_total"></a>}}
\if{latex}{\out{\hypertarget{method-Procedure-get_seconds_total}{}}}
\subsection{Method \code{get_seconds_total()}}{
Get the total optimization time in seconds of the alternating
optimization procedure.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Procedure$get_seconds_total()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Procedure-check_stopping"></a>}}
\if{latex}{\out{\hypertarget{method-Procedure-check_stopping}{}}}
\subsection{Method \code{check_stopping()}}{
Checks if the alternating optimization procedure can be terminated.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Procedure$check_stopping()}\if{html}{\out{</div>}}
}

}
}
