% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/orsf_vint.R
\name{orsf_vint}
\alias{orsf_vint}
\title{Variable Interactions}
\usage{
orsf_vint(
  object,
  predictors = NULL,
  n_thread = NULL,
  verbose_progress = NULL,
  sep = ".."
)
}
\arguments{
\item{object}{(\emph{ObliqueForest}) a trained oblique random forest object (see \link{orsf})}

\item{predictors}{(\emph{character}) a vector of length 2 or more with names
of predictors used by \code{object}. All pairwise interactions between
the predictors will be scored. If \code{NULL} (the default), all predictors
are used.}

\item{n_thread}{(\emph{integer}) number of threads to use while growing trees, computing predictions, and computing importance. Default is 0, which allows a suitable number of threads to be used based on availability.}

\item{verbose_progress}{(\emph{logical}) if \code{TRUE}, progress messages are
printed in the console. If \code{FALSE} (the default), nothing is printed.}

\item{sep}{(\emph{character}) how to separate the names of two predictors.
The default value of \code{".."} returns names as \code{name1..name2}}
}
\value{
a data.table with variable interaction scores and
partial dependence values.
}
\description{
Use the variable interaction score described in Greenwell et al (2018).
As this method can be computationally demanding, using \code{n_thread=0}
can substantially reduce time needed to compute scores.
}
\details{
The number of possible interactions grows exponentially based on the
number of predictors. Some caution is warranted when using large predictor
sets and it is recommended that you supply a specific vector of predictor
names to assess rather than a global search. A good strategy is to use
\code{n_tree = 5} to search all predictors, then pick the top 10 interactions,
get the unique predictors from them, and re-run on just those predictors
with more trees.
}
\examples{

set.seed(329)

data <- data.frame(
 x1 = rnorm(500),
 x2 = rnorm(500),
 x3 = rnorm(500)
)

data$y = with(data, expr = x1 + x2 + x3 + 1/2*x1 * x2 + x2 * x3 + rnorm(500))

forest <- orsf(data, y ~ ., n_tree = 5)

orsf_vint(forest)
}
\references{
\enumerate{
\item Greenwell, M B, Boehmke, C B, McCarthy, J A (2018). "A simple and
effective model-based variable importance measure." \emph{arXiv preprint
arXiv:1805.04755}.
}
}
