\name{rtree}
\alias{rtree}
\title{Generates Random Trees}
\usage{
rtree(n, br = TRUE)
}
\arguments{
  \item{n}{an integer giving the number of tips in the tree.}
  \item{br}{a logical specifying whether the tree should have branch
    lengths (default is \code{TRUE}).}
}
\description{
  This function generates a tree by splitting randomly the tips until
  the specified number of tips is obtained.
}
\details{
  If \code{br = TRUE}, branch lengths are taken from a uniform
  distribution on [0, 1].

  This is an experimental function and is not intended to generate trees
  with given statistical characteristics (at least for the moment). Its
  present purpose is to give a tree of a specified size in an easy
  way. To get an ultrametric tree, one may apply the function
  \code{\link{chronogram}} to the tree generated by \code{rtree}.
}
\author{Emmanuel Paradis \email{paradis@isem.univ-montp2.fr}}
\examples{
layout(matrix(1:9, 3, 3))
### Nine random trees:
for (i in 1:9) plot(rtree(20))
### Nine random cladograms:
for (i in 1:9) plot(rtree(20, FALSE), type = "c")
layout(matrix(1))
}
\keyword{datagen}
