% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apexcharter.R
\name{apexchart}
\alias{apexchart}
\title{Create a apexcharts.js widget}
\usage{
apexchart(
  ax_opts = list(),
  auto_update = TRUE,
  width = NULL,
  height = NULL,
  elementId = NULL
)
}
\arguments{
\item{ax_opts}{A \code{list} in JSON format with chart parameters.}

\item{auto_update}{In Shiny application, update existing chart rather than generating new one.}

\item{width}{A numeric input in pixels.}

\item{height}{A numeric input in pixels.}

\item{elementId}{Use an explicit element ID for the widget.}
}
\value{
A \code{apexcharts} \code{htmlwidget} object.
}
\description{
Create a apexcharts.js widget
}
\examples{
library(apexcharter)

# Use raw API by passing a list of
# parameters to the function

apexchart(ax_opts = list(
  chart = list(
    type = "bar"
  ),
  series = list(list(
    name = "Example",
    data = sample(1:100, 5)
  )),
  xaxis = list(
    categories = LETTERS[1:5]
  )
))


# Or use apexchart() to initialize the chart
# before passing parameters

apexchart() \%>\%
  ax_chart(type = "bar") \%>\%
  ax_series(
    list(
      name = "Example",
      data = sample(1:100, 5)
    )
  ) \%>\%
  ax_xaxis(
    categories = LETTERS[1:5]
  )
}
