% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apex-utils.R
\name{ax_yaxis2}
\alias{ax_yaxis2}
\title{Secondary Y-axis options}
\usage{
ax_yaxis2(ax, ...)
}
\arguments{
\item{ax}{A \code{apexcharts} \code{htmlwidget} object.}

\item{...}{See arguments from \code{\link{ax_yaxis}}.}
}
\value{
A \code{apexcharts} \code{htmlwidget} object.
}
\description{
Secondary Y-axis options
}
\examples{
library(apexcharter)
data("economics_long", package = "ggplot2")

eco <- economics_long \%>\%
  subset(variable \%in\% c("pce", "pop")) \%>\% 
  transform(value = round(value))

# add second y-axis
apex(eco, aes(x = date, y = value, color = variable), type = "line") \%>\%
  ax_yaxis(title = list(text = "Pce")) \%>\%
  ax_yaxis2(opposite = TRUE, title = list(text = "Pop"))

# Customize axis a bit more
apex(eco, aes(x = date, y = value, color = variable), type = "line") \%>\%
  ax_yaxis(
    title = list(text = "Pce"),
    axisBorder = list(
      show = TRUE,
      color = "#008FFB"
    ),
    labels = list(
      style = list(
        colors = "#008FFB"
      )
    ),
    tooltip = list(
      enabled = TRUE
    )
  ) \%>\%
  ax_yaxis2(
    opposite = TRUE, 
    min = 160000,
    forceNiceScale = TRUE,
    title = list(text = "Pop"),
    axisBorder = list(
      show = TRUE,
      color = "#00E396"
    ),
    labels = list(
      style = list(
        colors = "#00E396"
      )
    ),
    tooltip = list(
      enabled = TRUE
    )
  )
}
