% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colors.R
\name{ax_colors_manual}
\alias{ax_colors_manual}
\title{Set specific color's series}
\usage{
ax_colors_manual(ax, values)
}
\arguments{
\item{ax}{A \code{apexcharts} \code{htmlwidget} object.}

\item{values}{Named list, names represent data series, values colors to use.}
}
\value{
A \code{apexcharts} \code{htmlwidget} object.
}
\description{
Set specific color's series
}
\examples{
## scatter

apex(
  data = mtcars, 
  type = "scatter",
  mapping = aes(x = wt, y = mpg, fill = cyl)
) \%>\% 
  ax_colors_manual(list(
    "4" = "steelblue",
    "6" = "firebrick",
    "8" = "forestgreen"
  ))

# If missing level, colors are recycled
apex(
  data = mtcars, 
  type = "scatter",
  mapping = aes(x = wt, y = mpg, fill = cyl)
) \%>\% 
  ax_colors_manual(list(
    "4" = "steelblue",
    "8" = "forestgreen"
  ))

# Ignore levels not present in data
apex(
  data = mtcars, 
  type = "scatter",
  mapping = aes(x = wt, y = mpg, fill = cyl)
) \%>\% 
  ax_colors_manual(list(
    "4" = "steelblue",
    "6" = "firebrick",
    "8" = "forestgreen",
    "99" = "yellow"
  ))



## Bar

tab <- table(sample(letters[1:5], 100, TRUE), sample(LETTERS[1:5], 100, TRUE))
dat <- as.data.frame(tab)

apex(
  data = dat,
  type = "column",
  mapping = aes(x = Var1, y = Freq, group = Var2)
) \%>\% 
  ax_colors_manual(list(
    A = "steelblue",
    C = "firebrick",
    D = "forestgreen",
    B = "peachpuff",
    E = "chartreuse"
  ))
}
