% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimation.R
\name{aphylo_estimates}
\alias{aphylo_estimates}
\alias{print.aphylo_estimates}
\alias{coef.aphylo_estimates}
\alias{vcov.aphylo_estimates}
\alias{plot.aphylo_estimates}
\title{Objects of class \code{aphylo_estimates}}
\usage{
\method{print}{aphylo_estimates}(x, ...)

\method{coef}{aphylo_estimates}(object, ...)

\method{vcov}{aphylo_estimates}(object, ...)

\method{plot}{aphylo_estimates}(
  x,
  y = NULL,
  which.tree = 1L,
  ids = list(1:Ntip(x)[which.tree]),
  loo = TRUE,
  nsamples = 1L,
  ncores = 1L,
  centiles = c(0.025, 0.5, 0.975),
  cl = NULL,
  ...
)
}
\arguments{
\item{x, object}{Depending of the method, an object of class \code{aphylo_estimates}.}

\item{...}{Further arguments passed to the corresponding method.}

\item{y}{Ignored.}

\item{which.tree}{Integer scalar. Which tree to plot.}

\item{ids, nsamples, ncores, centiles, cl}{passed to \code{\link[=predict.aphylo_estimates]{predict.aphylo_estimates()}}}

\item{loo}{Logical scalar. When \code{loo = TRUE}, predictions are preformed
similar to what a leave-one-out cross-validation scheme would be done
(see \link{predict.aphylo_estimates}).}
}
\value{
Objects of class \code{aphylo_estimates} are a list withh the following elements:
\item{par}{A numeric vector of length 5 with the solution.}
\item{hist}{A numeric matrix of size \code{counts*5} with the solution path
(length 2 if used \code{optim} as the intermediate steps are not available to the
user). In the case of \code{aphylo_mcmc}, \code{hist} is an object of class
\code{\link[coda:mcmc.list]{coda::mcmc.list()}}.}
\item{ll}{A numeric scalar with the value of \code{fun(par, dat)}. The value of the log likelihood.}
\item{counts}{Integer scalar number of steps/batch performed.}
\item{convergence}{Integer scalar. Equal to 0 if \code{optim} converged. See \code{optim}.}
\item{message}{Character scalar. See \code{optim}.}
\item{fun}{A function (the objective function).}
\item{priors}{If specified, the function \code{priors} passed to the method.}
\item{dat}{The data \code{dat} provided to the function.}
\item{par0}{A numeric vector of length 5 with the initial parameters.}
\item{method}{Character scalar with the name of the method used.}
\item{varcovar}{A matrix of size 5*5. The estimated covariance matrix.}

The plot method for \code{aphylo_estimates} returns the selected tree
(\code{which.tree}) with predicted annotations, also of class \link{aphylo}.
}
\description{
The model fitting of annotated phylogenetic trees can be done using either
MLE via \code{\link[=aphylo_mle]{aphylo_mle()}} or MCMC via \code{\link[=aphylo_mcmc]{aphylo_mcmc()}}. This section describes
the object of class \code{aphylo_estimates} that these functions generate and
the post estimation methods/functions that can be used.
}
\details{
The plot method for the object of class \code{aphylo_estimates} plots
the original tree with the predicted annotations.
}
\examples{
set.seed(7881)
atree <- raphylo(40, P = 2)
res   <- aphylo_mcmc(atree ~ mu_d + mu_s + Pi)

print(res)
coef(res)
vcov(res)
plot(res)
}
