% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apollo_avgInterDraws.R
\name{apollo_avgInterDraws}
\alias{apollo_avgInterDraws}
\title{Averages inter-individual draws}
\usage{
apollo_avgInterDraws(P, apollo_inputs, functionality)
}
\arguments{
\item{P}{List of vectors, matrices or 3-dim arrays. Likelihood of the model components.}

\item{apollo_inputs}{List grouping most common inputs. Created by function \link{apollo_validateInputs}.}

\item{functionality}{Character. Description of the desired output from \code{apollo_probabilities}. Can take the values: "estimate", "prediction", "validate", "zero_LL", "conditionals", "output", "raw".}
}
\value{
Likelihood averaged over inter-individual draws (shape depends on argument \code{functionality}).
        \itemize{
          \item"estimate": Returns the likelihood of the model averaged across inter-individual draws.
          \item"prediction": Returns the likelihood of all alternatives and all model components across inter-individual draws.
          \item"validate": Returns P without changes.
          \item"zero_LL": Returns P without changes.
          \item"conditionals": Returns P without changes.
          \item"output": Returns the same as "estimate", but also prints a summary of the estimation data.
          \item"raw": Returns P without changes.
        }
}
\description{
Averages individual-specific likelihood across inter-individual draws.
}
