% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apollo_makeGrad.R
\name{apollo_makeGrad}
\alias{apollo_makeGrad}
\title{Creates gradient function.}
\usage{
apollo_makeGrad(
  apollo_beta,
  apollo_fixed,
  apollo_logLike,
  validateGrad = FALSE
)
}
\arguments{
\item{apollo_beta}{Named numeric vector. Names and values for parameters.}

\item{apollo_fixed}{Character vector. Names (as defined in \code{apollo_beta}) of parameters whose value should not 
change during estimation.}

\item{apollo_logLike}{Function to calculate the loglikelihood of the model, as created by \link{apollo_makeLogLike}
If provided, the value of the analytical gradient will be compared to the value of the
numerical gradient as calculated using apollo_logLike and the numDeriv package.
If the difference between the two is bigger than 1% for any dimension, it will be assumed
that the analytical gradient is wrong and NULL will be returned.}

\item{validateGrad}{Logical. If TRUE, it compares the value of the analytical gradient evaluated at apollo_beta
against the numeric gradient (using numDeriv) at the same value. If the difference is bigger
than 1% for any dimension, it will assume that the analytical gradient is wrong and will
return NULL.}
}
\value{
apollo_gradient function. It receives the following arguments
        \itemize{
          \item \code{b} Numeric vector of _variable_ parameters (i.e. must not include fixed parameters).
          \item \code{countIter} Not used. Included only to mirror inputs of apollo_logLike.
          \item \code{writeIter} Not used. Included only to mirror inputs of apollo_logLike.
          \item \code{sumLL} Not used. Included only to mirror inputs of apollo_logLike.
          \item \code{getNIter} Not used. Included only to mirror inputs of apollo_logLike.
        }
        If the creation of the gradient function fails, then it returns NULL.
}
\description{
Creates gradient function from the likelihood function apollo_probabilities provided by the user. Returns NULL if 
the creation of gradient function fails.
}
\details{
Internal use only. Called by \code{apollo_estimate} before estimation.
The returned function can be single-threaded or multi-threaded based on the model options.
}
