% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apollo_lcEM.R
\name{apollo_lcEM}
\alias{apollo_lcEM}
\title{Uses EM for latent class model}
\usage{
apollo_lcEM(
  apollo_beta,
  apollo_fixed,
  apollo_probabilities,
  apollo_inputs,
  lcEM_settings = NA,
  estimate_settings = NA
)
}
\arguments{
\item{apollo_beta}{Named numeric vector. Names and values for parameters.}

\item{apollo_fixed}{Character vector. Names (as defined in \code{apollo_beta}) of parameters whose value should not 
change during estimation.}

\item{apollo_probabilities}{Function. Returns probabilities of the model to be estimated. Must receive three arguments:
\itemize{
  \item apollo_beta: Named numeric vector. Names and values of model parameters.
  \item apollo_inputs: List containing options of the model. See \link{apollo_validateInputs}.
  \item functionality: Character. Can be either "estimate" (default), "prediction", 
        "validate", "conditionals", "zero_LL", or "raw".
}}

\item{apollo_inputs}{List grouping most common inputs. Created by function \link{apollo_validateInputs}.}

\item{lcEM_settings}{List. Options controlling the EM process.
\itemize{
  \item \strong{stoppingCriterion}: Numeric. Convergence criterion. The EM process will stop when 
                                    improvements in the log-likelihood fall below this value. 
                                    Default is 10^-5.
  \item \strong{EMmaxIterations}: Numeric. Maximum number of iterations of the EM algorithm before 
                                  stopping. Default is 100. Used only if \code{apollo_control$HB} 
                                  is FALSE. Default is 200.
  \item \strong{postEM}: Numeric scalar. Determines the number of tasks performed by this function 
                         after the EM algorithm has converged. Can take values \code{0}, \code{1} 
                         or \code{2} only. If value is \code{0}, only the EM algorithm will be 
                         performed, and the results will be a model object without a covariance 
                         matrix (i.e. estimates only.). If value is \code{1}, after the EM 
                         algorithm the covariance matrix of the model will be calculated as well, 
                         and the result will be a model object with a covariance matrix. If value 
                         is \code{2}, after the EM algorithm, the estimated parameter values will 
                         be used as starting value for a maximum likelihood estimation process, 
                         which will render a model object with a covariance matrix. Performing 
                         maximum likelihood estimation after the EM algorithm is useful, as there 
                         may be room for further improvement. Default is \code{2}.
  \item \strong{silent}: Boolean. If TRUE, no information is printed to the console during 
                         estimation. Default is FALSE.
}}

\item{estimate_settings}{List. Options controlling the estimation process within each EM iteration. See 
\link{apollo_estimate} for details.}
}
\value{
model object
}
\description{
Uses the EM algorithm for estimating a latent class model.
}
\details{
This function uses the EM algorithm for estimating a Latent Class model. It is only suitable for models without 
continuous mixing. All parameters that vary across classes need to be included in the \code{apollo_lcPars} 
function which is used by \code{apollo_lcEM}.
}
