% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/info.R
\name{lookup_apple}
\alias{lookup_apple}
\title{Apple Store Lookup}
\usage{
lookup_apple(
  id,
  country = NULL,
  entity = NULL,
  limit = NULL,
  sort = NULL,
  id_type = "id"
)
}
\arguments{
\item{id}{The ID of the iTunes entity}

\item{country}{The two-letter country code for the store you want to search.
For a list of country codes see \url{https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2}}

\item{entity}{\code{Optional} The type of results you want returned, relative to the specified media type.}

\item{limit}{\code{Optional} The number of search results you want the iTunes Store to return between 1 and 200.
The default is 50.}

\item{sort}{\code{Optional} The order the results are returned, for most recent first select \code{recent}.}

\item{id_type}{The ID type to lookup, options are:
\describe{
\item{\code{id}}{The default iTunes ID}
\item{\code{amgArtistId}}{AMG Artist ID}
\item{\code{amgAlbumId}}{AMG Album ID}
\item{\code{upc}}{UPC Album or Video ID}
\item{\code{isbn}}{ISB Book ID}
}}
}
\value{
A \code{data.frame} of any results that match the iTunes database.

If there were no successful results then it will return \code{NULL}.
}
\description{
You can create a lookup request to search for content in the stores based on iTunes IDs, UPCs/EANs,
and All Music Guide (AMG) IDs. ID-based lookups are faster and contain fewer false-positive results.
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Look up Jack Johnson by iTunes artist ID
lookup_apple(909253)

# Look up Jack Johnson by AMG artist ID
lookup_apple(468749, id_type = "amgArtistId")
\dontshow{\}) # examplesIf}
}
\seealso{
\url{https://performance-partners.apple.com/resources/documentation/itunes-store-web-service-search-api.html}
}
