% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hat_values-score.R
\name{score.apd_hat_values}
\alias{score.apd_hat_values}
\title{Score new samples using hat values}
\usage{
\method{score}{apd_hat_values}(object, new_data, type = "numeric", ...)
}
\arguments{
\item{object}{A \code{apd_hat_values} object.}

\item{new_data}{A data frame or matrix of new predictors.}

\item{type}{A single character. The type of predictions to generate.
Valid options are:
\itemize{
\item \code{"numeric"} for a numeric value that summarizes the hat values for
each sample across the training set.
}}

\item{...}{Not used, but required for extensibility.}
}
\value{
A tibble of predictions. The number of rows in the tibble is guaranteed
to be the same as the number of rows in \code{new_data}. For \code{type = "numeric"},
the tibble contains two columns \code{hat_values} and \code{hat_values_pctls}. The
column \code{hat_values_pctls} is in percent units so that a value of 11.5
indicates that, in the training set, 11.5 percent of the training set
samples had smaller values than the sample being scored.
}
\description{
Score new samples using hat values
}
\examples{
train_data <- mtcars[1:20,]
test_data <- mtcars[21:32,]

hat_values_model <- apd_hat_values(train_data)

hat_values_scoring <- score(hat_values_model, new_data = test_data)
hat_values_scoring

}
