% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{autoplot.apd_pca}
\alias{autoplot.apd_pca}
\title{Plot the distribution function for principal components}
\usage{
\method{autoplot}{apd_pca}(object, ...)
}
\arguments{
\item{object}{An object produced by \code{apd_pca}.}

\item{...}{An optional set of \code{dplyr} selectors, such as \code{dplyr::matches()} or
\code{dplyr::starts_with()} for selecting which variables should be shown in the
plot.}
}
\value{
A \code{ggplot} object that shows the distribution function for each
principal component.
}
\description{
Plot the distribution function for principal components
}
\examples{
library(ggplot2)
library(dplyr)
library(modeldata)
data(biomass)

biomass_ad <- apd_pca(biomass[, 3:8])

autoplot(biomass_ad)
# Using selectors in `...`
autoplot(biomass_ad, distance) + scale_x_log10()
autoplot(biomass_ad, matches("PC[1-2]"))
}
