% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compdist.R
\name{compdist}
\alias{compdist}
\title{Comparison Distribution Descriptives}
\usage{
compdist(a, b, model, output, lambda1, lambda2, trim, strat1, strat2)
}
\arguments{
\item{a}{a vector containing the sum of square errors or
-2 * log likelihood estimates derived using modelling strategy 1.}

\item{b}{a vector containing the sum of square errors or
-2 * log likelihood estimates derived using modelling strategy 2.}

\item{model}{type of regression model. Either "linear" or "logistic".}

\item{output}{logical. If output is TRUE the function will return two
graphical representations of the comparison distribution.}

\item{lambda1}{a vector or matrix containing the estimated shrinkage factors
derived using strategy 1}

\item{lambda2}{a vector or matrix containing the estimated shrinkage factors
derived using strategy 2}

\item{trim}{logical. If trim is TRUE a "trimmed" comparison distribution
will be returned, along with a victory rate and median precision
ratio derived using the trimmed distribution. The trimmed
distribution only contains precision ratios within a range of
plus or minus two times the interquartile range around the
median precision ratio.}

\item{strat1}{a list containing the strategy name and strategy-specific
parameter values.}

\item{strat2}{a list containing the strategy name and strategy-specific
parameter values.}
}
\description{
calculate a comparison distribution and associated descriptive statisics.
}
\details{
This function works within \code{compare} to calculate the comparison
distribution of strategy 2 against strategy 1. If \code{trim == TRUE}, a
truncated distribution consisting of +/- 2 * interquartile range around the
median precision ratio.

The victory rate for linear regression is the left tail probability with
a cut-off of 1. The victory rate for logistic regression instead taken
at a cut-off of 0. For more details, refer to the accompanying PDF document.

If \code{output == TRUE} the function will plot a histogram of the distribution
and a scatterplot of the precision (SSE or -2 log likelihood) of strategy 2 against
strategy 1. Points that lie below the red or blue line represent trials in which
strategy 2 outperformed strategy 1 (the victory rate).
}
\note{
For details of returned values and examples see \code{\link{compare}}.
}

