% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ml.rgr.R
\name{ml.rgr}
\alias{ml.rgr}
\title{Logistic Regression with Maximum Likelihood Estimation}
\usage{
ml.rgr(dataset)
}
\arguments{
\item{dataset}{a \code{p} x \code{m} data matrix, where the final column is a
binary outcome variable. \code{datashape} may be applied to data so that
the dataset is in the correct format for this function (see manual)}
}
\value{
The function returns a column-vector containing the logistic
        regression coefficients and intercept (if specified).
}
\description{
Fit a logistic regression model using maximum likelihood estimation
}
\details{
This function is a wrapper for \code{\link[stats]{glm.fit}}, for convenient
application within several functions in the \pkg{apricomp} package. This function may
be called directly. For regression with an intercept included, the first column in
the dataset must be a column of 1s.
}
\examples{
## Logistic regression using a subset of the mtcars data (outcome is "vs")
data(mtcars)
mtc.df <- mtcars[, c(8, 1, 9)]
mtc.shaped <- datashape(dataset = mtc.df, y = 1)
ml.rgr(mtc.shaped)
ml.rgr(cbind(1,mtc.shaped))
}

