% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SoilProfileCollection-methods.R
\docType{methods}
\name{unique}
\alias{unique}
\alias{unique,SoilProfileCollection-method}
\title{Get the indexes of unique profiles in a SoilProfileCollection}
\usage{
\S4method{unique}{SoilProfileCollection}(x, vars)
}
\arguments{
\item{x}{a SoilProfileCollection}

\item{vars}{Variables to consider in uniqueness.}
}
\description{
Calculate MD5 hash of each profile in a SoilProfileCollection for the specified variables.
}
\examples{

data(sp5)

# find indices where all specified vars are unique
#  these match the indices of all profiles in sp5
#  therefore, all profiles in sp5 are unique

all(unique(sp5, vars=c("id","sand","silt","clay") == 1:length(sp5)))

}
