% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/soilPalette.R
\name{soilPalette}
\alias{soilPalette}
\title{Soil Color Palette}
\usage{
soilPalette(
  colors,
  lab = colors,
  lab.cex = 0.75,
  dynamic.labels = TRUE,
  x.inset = 0.01,
  y.inset = 0.01,
  ...
)
}
\arguments{
\item{colors}{vector of hex colors (e.g. #A66E46FF)}

\item{lab}{vector of labels}

\item{lab.cex}{character scaling for labels}

\item{dynamic.labels}{logical, adjust label colors for maximum contrast via \code{invertLabelColor}}

\item{x.inset}{horizontal adjustment for labels}

\item{y.inset}{vertical adjustment for labels}

\item{\dots}{further arguments to \code{colorspace::swatchplot}}
}
\description{
A very simple function for generating labeled swatches of soil colors. Largely based on \code{colorspace::swatchplot}.
}
\note{
The result is a simple figure on the active plotting device.
}
\examples{

# maybe useful for teaching about soil color

par(mfrow=c(2,1), mar=c(1,1,1,1))

# demonstrate range of Munsell value
m <- sprintf('10YR \%s/4', 2:8)
# convert to hex representation
cols <- parseMunsell(m)
# plot
soilPalette(cols, m)

# demonstrate range of Munsell chroma
m <- sprintf('10YR 4/\%s', 2:8)
# convert to hex representation
cols <- parseMunsell(m)
# plot
soilPalette(cols, m)

}
\author{
D.E. Beaudette
}
\keyword{hplots}
