% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cba.R
\name{cba}
\alias{cba}
\title{CBA Classifier}
\usage{
cba(train, classAtt, rulelearning_options = NULL, pruning_options = NULL)
}
\arguments{
\item{train}{a data frame with data.}

\item{classAtt}{the name of the class attribute.}

\item{rulelearning_options}{custom options for the rule learning algorithm overriding the default values.
If not specified, the the   \link{topRules} function is called and defaults specified there are used\cr
\code{target_rule_count} (int) mining stops when the resulting rule set contains this number of rules; \cr
\code{trim} (boolean) if set to TRUE and more than \code{target_rule_count} is discovered, only first \code{target_rule_count} rules will be returned. \cr
\code{minsupp} (float)  minimum support threshold  \cr
\code{minconf} (float) minimum confidence threshold \cr
\code{minlen} (int) minimum length of rules, minlen=1 corresponds to rule with empty antecedent and one item in consequent. In general, rules with empty antecedent are not desirable for the subsequent pruning algorithm, therefore the value of this parameter should be set at least to value 2. \cr
\code{maxlen}  (int) maximum length of rules, should be equal or higher than minlen. A higher value may decrease the number of iterations to obtain target_rule_count rules, but it also increases the risk of initial combinatorial explosion and subsequent memory crash of the apriori rule learner. \cr
\code{maxtime} (int) maximum number of seconds it should take `apriori` to obtain rules. \cr
\code{find_conf_supp_thresholds} (boolean) whether to use automatic threshold detection or not. \cr}

\item{pruning_options}{custom options for the pruning algorithm overriding the default values. \cr}
}
\value{
Object of class \link{CBARuleModel}.
}
\description{
Learns a CBA rule set from supplied dataframe.
}
\examples{
 # Example using automatic threshold detection
  cba(datasets::iris, "Species", rulelearning_options = list(target_rule_count = 50000))
 # Example using manually set confidence and support thresholds
  rm <- cba(datasets::iris, "Species", rulelearning_options = list(minsupp=0.01,
   minconf=0.5, minlen=1, maxlen=5, maxtime=1000, target_rule_count=50000, trim=TRUE,
   find_conf_supp_thresholds=FALSE))
  inspect(rm@rules)
}
