% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloneGitHubRepo.R
\name{cloneGitHubRepo}
\alias{cloneGitHubRepo}
\title{Clone Github Repository}
\usage{
cloneGitHubRepo(repoURL, repoDir = NULL, default = FALSE, ...)
}
\arguments{
\item{repoURL}{The remote repository to clone.}

\item{repoDir}{Local directory to clone to. If \code{NULL}, by default, creates a local directory,
which corresponds to the name after last \code{/} in \code{repoURL}.}

\item{default}{Sets cloned Repository as default Local and GitHub Repository. 
If \code{default = TRUE} then \code{repoDir} (last piece of \code{repoURL}) is set as default Local Repository 
 and for GitHub repository also the \code{user} from  \code{repoURL} is set as default GitHub user).}

\item{...}{Further parameters passed to \link[git2r]{clone}.}
}
\description{
\code{cloneGitHubRepo} is a wrapper around \code{git clone} and clones GitHub Repository
into the \code{repoDir} directory.
}
\details{
To learn more about  \code{Archivist Integration With GitHub} visit \link{agithub}.
}
\examples{
\dontrun{

cloneGitHubRepo("https://github.com/MarcinKosinski/Museum")
cloneGitHubRepo("https://github.com/MarcinKosinski/Museum-Extra")


# empty Github Repository creation

library(httr)
myapp <- oauth_app("github",
                   key = app_key,
                   secret = app_secret)
github_token <- oauth2.0_token(oauth_endpoints("github"),
                               myapp,
                               scope = "public_repo")
# setting options                              
aoptions("github_token", github_token)
aoptions("name", user_name)
aoptions("password", user_password)

createEmptyGithubRepo("archive-test4")
setRemotebRepo(aoptions("name"), "archive-test4")
## artifact's archiving
example <- 1:100

# archiving
archive(example) -> md5hash_path

## proof that artifact is really archived
showRemoteRepo() # uses options from setGithubRepo
# let's remove przyklad
rm(example)
# and load it back from md5hash_path
aread(md5hash_path)


# clone example
unlink("archive-test", recursive = TRUE)
cloneGitHubRepo('https://github.com/MarcinKosinski/archive-test')
setRemoteRepo(aoptions("name"), "archive-test")
# equivalent is cloneGitHubRepo('https://github.com/MarcinKosinski/archive-test', default = TRUE)
# check if default is set with
# aoptions('repoDir'); aoptions('repo'); aoptions('user')
data(iris)
archive(iris)
showRemoteRepo()


}
}
\author{
Marcin Kosinski, \email{m.p.kosinski@gmail.com}
}
\seealso{
Other archivist.github: \code{\link{archive}},
  \code{\link{createGitHubRepo}},
  \code{\link{deleteGitHubRepo}}
}

