% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/addTagsRepo.R
\name{addTagsRepo}
\alias{addTagsRepo}
\title{Add new Tags to the Existing Repository}
\usage{
addTagsRepo(md5hashes, repoDir = NULL, FUN = NULL, tags = NULL, ...)
}
\arguments{
\item{md5hashes}{To which corresponding artifacts should \code{Tags} be added.}

\item{repoDir}{A character that specifies the directory of the Repository into which
new \code{Tags} will be added. If set to \code{NULL} (by default), uses the \code{repoDir} specified in \link{setLocalRepo}.}

\item{FUN}{A function that evaluates on the artifacts for which \code{md5hashes} are given and generates
\code{Tags} as a result that will be added to the local Repository. Can be specified only one of: \code{FUN}
or \code{tags}.}

\item{tags}{A character vector that specifies what tag should be added to which artifact that
corresponds to given \code{md5hash}. Can be specified only one of: \code{FUN}
or \code{tags}. Should have length 1 or the same as length of \code{md5hashes} param.}

\item{...}{Other arguments that will be passed to FUN.}
}
\description{
\code{addTagsRepo} adds new \link{Tags} to the existing \link{Repository}.
}
\details{
The \code{addTagsRepo} function adds new tags to artifacts that are already stored in repository.
 One can add new \code{tags} explicitly with \code{tags} argument, or by passing a
 function that extracts \code{tags} from selected artifacts specified by passing their \link{md5hash}.
To learn more about artifacts visit \link[archivist]{archivist-package}.

\code{Tags} are attributes of an artifact. \code{Tags} can be an artifact's \code{name}, \code{class} or \code{archiving date}.
Furthermore, for various artifact's classes more different \code{Tags} are available and can
be searched in \link{searchInLocalRepo} or \link{searchInGithubRepo} functions.
}
\examples{
\dontrun{

# Takes all objects of lm class from repository,
# extracts R2 for them and stores as R2: tags

exampleRepoDir <- tempdir()
createEmptyRepo(exampleRepoDir, force=TRUE)
m1 <- lm(Sepal.Length~Species, iris)
saveToRepo(m1, exampleRepoDir)
m1 <- lm(Sepal.Width~Species, iris)
saveToRepo(m1, exampleRepoDir)
getTagsLocal("da1bcaf68752c146903f700c1a458438", exampleRepoDir, "")
md5hashes <- searchInLocalRepo(repoDir=exampleRepoDir, "class:lm")
addTagsRepo(md5hashes, exampleRepoDir, tags = "test")
addTagsRepo(md5hashes, exampleRepoDir, function(x) paste0("R2:",summary(x)$r.square))
getTagsLocal("da1bcaf68752c146903f700c1a458438", exampleRepoDir, "")
showLocalRepo(exampleRepoDir)
deleteRepo(exampleRepoDir)
}
}
\author{
Marcin Kosinski, \email{m.p.kosinski@gmail.com},
Przemyslaw Biecek, \email{przemyslaw.biecek@gmail.com}
}
\seealso{
Other archivist: \code{\link{Repository}};
  \code{\link{Tags}}; \code{\link{\%a\%}};
  \code{\link{ahistory}}, \code{\link{print.ahistory}};
  \code{\link{aoptions}}; \code{\link{archivist-package}};
  \code{\link{aread}}; \code{\link{asearch}};
  \code{\link{cache}}; \code{\link{copyGithubRepo}},
  \code{\link{copyLocalRepo}};
  \code{\link{createEmptyRepo}}; \code{\link{deleteRepo}};
  \code{\link{getTagsGithub}}, \code{\link{getTagsLocal}};
  \code{\link{loadFromGithubRepo}},
  \code{\link{loadFromLocalRepo}}; \code{\link{md5hash}};
  \code{\link{multiSearchInGithubRepo}},
  \code{\link{multiSearchInLocalRepo}},
  \code{\link{searchInGithubRepo}},
  \code{\link{searchInLocalRepo}};
  \code{\link{rmFromRepo}}; \code{\link{saveToRepo}};
  \code{\link{setGithubRepo}}, \code{\link{setLocalRepo}};
  \code{\link{shinySearchInLocalRepo}};
  \code{\link{showGithubRepo}},
  \code{\link{showLocalRepo}};
  \code{\link{summaryGithubRepo}},
  \code{\link{summaryLocalRepo}};
  \code{\link{zipGithubRepo}}, \code{\link{zipLocalRepo}}
}

