% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addTagsRepo.R
\name{addTagsRepo}
\alias{addTagsRepo}
\title{Add new Tags to the Existing Repository}
\usage{
addTagsRepo(md5hashes, repoDir = NULL, FUN = NULL, tags = NULL, ...)
}
\arguments{
\item{md5hashes}{a character vector of \code{md5hashes} specifying to which
corresponding artifacts new \code{Tags} should be added. See \code{Note} 
to get to know about the length of \code{tags} and \code{md5hashes} parameters.}

\item{repoDir}{A character that specifies the directory of the Repository to which
new \code{Tags} will be added. If it is set to \code{NULL} (by default),
it uses the \code{repoDir} specified in \link{setLocalRepo}.}

\item{FUN}{A function which is evaluated on the artifacts for which \code{md5hashes}
are given. The result of this function evaluation are \code{Tags} which will
be added to the local Repository.}

\item{tags}{A character vector which specifies what kind of Tags should be added to
artifacts corresponding to given \code{md5hashes}. See \code{Note} to get to know about
the length of \code{tags} and \code{md5hashes} parameters.
One can specify either \code{FUN} or \code{tags}.}

\item{...}{Other arguments that will be passed to FUN.}
}
\description{
\code{addTagsRepo} adds new \link{Tags} to the existing \link{Repository}.
}
\details{
\code{addTagsRepo} function adds new Tags to artifacts that are already stored
in the repository. One can add new \code{Tags} either explicitly with \code{tags} parameter
or by passing a function which extracts \code{Tags} from selected artifacts
corresponding to \code{md5hashes}. To learn more about artifacts visit
\link[archivist]{archivist-package}.
}
\note{
One should remember that \code{length(tags)} modulo \code{length(md5hashes)} 
must be equal to 0 or \code{length(md5hashes)} modulo \code{length(tags)}
must be equal to 0.
}
\section{Contact}{

 
Bug reports and feature requests can be sent to 
\href{https://github.com/pbiecek/archivist/issues}{https://github.com/pbiecek/archivist/issues}
}

\examples{
\dontrun{

## We Take all artifacts of lm class from repository, 
## extract R^2 for them and store as R^2:number Tags

# Creating empty repository
exampleRepoDir <- tempfile()
createLocalRepo(exampleRepoDir, force=TRUE)

# Saving lm artifacts into repository
m1 <- lm(Sepal.Length~Species, iris)
saveToLocalRepo(m1, exampleRepoDir)
m2 <- lm(Sepal.Width~Species, iris)
saveToLocalRepo(m2, exampleRepoDir)

# We may see what kind of Tags are related to "m1" artifact corresponding to
# "9e66edd297c2f291446f3503c01d443a" md5hash
getTagsLocal("9e66edd297c2f291446f3503c01d443a", exampleRepoDir, "")

# We may see what kind of Tags are related to "m2" artifact corresponding to
# "da1bcaf68752c146903f700c1a458438" md5hash
getTagsLocal("da1bcaf68752c146903f700c1a458438", exampleRepoDir, "")

# We Take all objects of lm class from repository
md5hashes <- searchInLocalRepo(repoDir=exampleRepoDir, "class:lm")

# Adding new tag "test" explicitly
addTagsRepo(md5hashes, exampleRepoDir, tags = "test")

# Adding new tag "R^2: " using FUN parameter
addTagsRepo(md5hashes, exampleRepoDir, function(x) paste0("R^2:",summary(x)$r.square))

# And now: Tags related to "m1" artifact are
getTagsLocal("9e66edd297c2f291446f3503c01d443a", exampleRepoDir, "")

# And now: Tags related to "m2" artifact are
getTagsLocal("da1bcaf68752c146903f700c1a458438", exampleRepoDir, "")

# One more look at our Repo
showLocalRepo(exampleRepoDir, method = "tags")

# Deleting example repository
deleteLocalRepo(exampleRepoDir, deleteRoot=TRUE)
rm(exampleRepoDir)
}

}
\references{
Biecek P and Kosinski M (2017). "archivist: An R Package for Managing,
Recording and Restoring Data Analysis Results." _Journal of Statistical
Software_, *82*(11), pp. 1-28. doi: 10.18637/jss.v082.i11 (URL:
http://doi.org/10.18637/jss.v082.i11).
URL https://github.com/pbiecek/archivist
}
\seealso{
Other archivist: 
\code{\link{Repository}},
\code{\link{Tags}},
\code{\link{\%a\%}()},
\code{\link{addHooksToPrint}()},
\code{\link{aformat}()},
\code{\link{ahistory}()},
\code{\link{alink}()},
\code{\link{aoptions}()},
\code{\link{archivist-package}},
\code{\link{areadLocal}()},
\code{\link{aread}()},
\code{\link{asearchLocal}()},
\code{\link{asearch}()},
\code{\link{asession}()},
\code{\link{atrace}()},
\code{\link{cache}()},
\code{\link{copyLocalRepo}()},
\code{\link{createLocalRepo}()},
\code{\link{createMDGallery}()},
\code{\link{deleteLocalRepo}()},
\code{\link{getRemoteHook}()},
\code{\link{getTagsLocal}()},
\code{\link{loadFromLocalRepo}()},
\code{\link{md5hash}},
\code{\link{removeTagsRepo}()},
\code{\link{restoreLibs}()},
\code{\link{rmFromLocalRepo}()},
\code{\link{saveToLocalRepo}()},
\code{\link{searchInLocalRepo}()},
\code{\link{setLocalRepo}()},
\code{\link{shinySearchInLocalRepo}()},
\code{\link{showLocalRepo}()},
\code{\link{splitTagsLocal}()},
\code{\link{summaryLocalRepo}()},
\code{\link{zipLocalRepo}()}
}
\author{
Marcin Kosinski, \email{m.p.kosinski@gmail.com}, 
Przemyslaw Biecek, \email{przemyslaw.biecek@gmail.com}
}
\concept{archivist}
