% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/locations.R
\name{pharm_cbsa}
\alias{pharm_cbsa}
\title{Get the core-based statistical area GEOID for each pharmacy based on BUYER_DEA_NO (Only includes retail and chain pharmacy designations)}
\usage{
pharm_cbsa(geoid = "26580", county = "Mingo", state = "WV", key = "WaPo")
}
\arguments{
\item{geoid}{Filter the data to only this cbsa GEOD (e.g. '26580')}

\item{county}{If geoid not included, filter the data to only this county (e.g. 'Mingo')}

\item{state}{If geoid not included, filter the data to county within this state (e.g. 'WV')}

\item{key}{Key needed to make query successful}
}
\description{
Get the core-based statistical area GEOID for each pharmacy based on BUYER_DEA_NO (Only includes retail and chain pharmacy designations)
}
\examples{
\donttest{
library(arcos)

mingo_wv <- pharm_cbsa(geoid="26580", key="WaPo")

head(mingo_wv)
}
}
\seealso{
\url{https://www.washingtonpost.com/graphics/2019/investigations/dea-pain-pill-database/#download-resources}

Other geocoded data: 
\code{\link{buyer_addresses}()},
\code{\link{county_population}()},
\code{\link{not_pharmacies}()},
\code{\link{pharm_counties}()},
\code{\link{pharm_latlon}()},
\code{\link{pharm_tracts}()},
\code{\link{reporter_addresses}()},
\code{\link{state_population}()}
}
\concept{geocoded data}
