% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_layers.R
\name{plot_layer}
\alias{plot_layer}
\alias{plot_layer.sf}
\title{Plot a spatial layer}
\usage{
plot_layer(x, ...)

plot_layer.sf(
  x,
  outline_poly = NULL,
  outline_size = 1.2,
  outline_color = "gray30",
  plot_pkg = "ggplot",
  ...
)
}
\arguments{
\item{x}{An sf or Raster* object as returned from a
\code{get_*_layer} function}

\item{...}{Additional arguments to \code{plot_layer}}

\item{outline_poly}{Optional. An sf polygon to outline \code{sf_data} for
context}

\item{outline_size}{Numeric argument that controls width of parameter}

\item{outline_color}{A character vector of a valid color}

\item{plot_pkg}{Character. The plotting environment to use. Either "ggplot"
(default) or "base"}
}
\value{
Either a \code{ggplot} object, or simply plots \code{x} if
\code{plot_pkg = "base"}
}
\description{
This function plots a spatial layer as returned from
\code{\link{get_spatial_layer}}.
}
\examples{
\dontrun{
plot_layer(iceland_poly)
plot_layer(portage_county, outline_poly = wis_poly)
}
}
