% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/triangles.R
\name{triangle_area}
\alias{triangle_area}
\title{Area of triangles}
\usage{
triangle_area(x, signed = FALSE)
}
\arguments{
\item{x}{coordinates x,y triplets matrix where 'nrow(x) = ntriangles*3'}

\item{signed}{defaults to \code{FALSE} and absolute value of area is returned,
if \code{TRUE} negative means clockwise 'p->q->r' turns right and positive means
counter-clockwise 'p->q->r' turns left}
}
\value{
numeric vector of area
}
\description{
Calculate triangle area from a matrix of coordinates. Triangles are composed
of three coordinates, so the matrix should have this as triplets of rows
one after the other.
}
\details{
If \code{signed = FALSE} the absolute value of area is returned, otherwise the
sign reflects path orientation. Positive means counter-clockwise orientation.

The algorithm was once documented at 'w w w cs.tufts.edu/comp/163/OrientationTests.pdf'
}
\examples{
sum(triangle_area(mm_tri$P[t(mm_tri$T), ]))

}
