% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forde.R
\name{forde}
\alias{forde}
\title{Forests for Density Estimation}
\usage{
forde(
  arf,
  x,
  oob = FALSE,
  family = "truncnorm",
  alpha = 0,
  epsilon = 0,
  parallel = TRUE
)
}
\arguments{
\item{arf}{Pre-trained \code{\link{adversarial_rf}}. Alternatively, any
object of class \code{ranger}.}

\item{x}{Training data for estimating parameters.}

\item{oob}{Only use out-of-bag samples for parameter estimation? If
\code{TRUE}, \code{x} must be the same dataset used to train \code{arf}.}

\item{family}{Distribution to use for density estimation of continuous
features. Current options include truncated normal (the default
\code{family = "truncnorm"}) and uniform (\code{family = "unif"}). See
Details.}

\item{alpha}{Optional pseudocount for Laplace smoothing of categorical
features. This avoids zero-mass points when test data fall outside the
support of training data. Effectively parametrizes a flat Dirichlet prior
on multinomial likelihoods.}

\item{epsilon}{Optional slack parameter on empirical bounds when
\code{family = "unif"}. This avoids zero-density points when test data fall
outside the support of training data. The gap between lower and upper
bounds is expanded by a factor of \code{1 + epsilon}.}

\item{parallel}{Compute in parallel? Must register backend beforehand, e.g.
via \code{doParallel}.}
}
\value{
A \code{list} with 5 elements: (1) parameters for continuous data; (2)
parameters for discrete data; (3) leaf indices and coverage; (4) metadata on
variables; and (5) the data input class. This list is used for estimating
likelihoods with \code{\link{lik}} and generating data with \code{\link{forge}}.
}
\description{
Uses a pre-trained ARF model to estimate leaf and distribution parameters.
}
\details{
\code{forde} extracts leaf parameters from a pretrained forest and learns
distribution parameters for data within each leaf. The former includes
coverage (proportion of data falling into the leaf) and split criteria. The
latter includes proportions for categorical features and mean/variance for
continuous features. These values are stored in a \code{data.table}, which
can be used as input to various other functions.

Currently, \code{forde} only provides support for a limited number of
distributional families: truncated normal or uniform for continuous data,
and multinomial for discrete data. Future releases will accommodate a larger
set of options.

Though \code{forde} was designed to take an adversarial random forest as
input, the function's first argument can in principle be any object of class
\code{ranger}. This allows users to test performance with alternative
pipelines (e.g., with supervised forest input). There is also no requirement
that \code{x} be the data used to fit \code{arf}, unless \code{oob = TRUE}.
In fact, using another dataset here may protect against overfitting. This
connects with Wager & Athey's (2018) notion of "honest trees".
}
\examples{
arf <- adversarial_rf(iris)
psi <- forde(arf, iris)
head(psi)


}
\references{
Watson, D., Blesch, K., Kapar, J., & Wright, M. (2022). Adversarial random
forests for density estimation and generative modeling. \emph{arXiv} preprint,
2205.09435.

Wager, S. & Athey, S. (2018). Estimation and inference of heterogeneous
treatment effects using random forests. \emph{J. Am. Stat. Assoc.},
\emph{113}(523): 1228-1242.
}
\seealso{
\code{\link{adversarial_rf}}, \code{\link{forge}}, \code{\link{lik}}
}
