% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forge.R
\name{forge}
\alias{forge}
\title{Forests for Generative Modeling}
\usage{
forge(params, n_synth, evidence = NULL)
}
\arguments{
\item{params}{Circuit parameters learned via \code{\link{forde}}.}

\item{n_synth}{Number of synthetic samples to generate.}

\item{evidence}{Optional set of conditioning events. This can take one of
three forms: (1) a partial sample, i.e. a single row of data with
some but not all columns; (2) a data frame of conditioning events,
which allows for inequalities; or (3) a posterior distribution over leaves.
See Details.}
}
\value{
A dataset of \code{n_synth} synthetic samples.
}
\description{
Uses pre-trained FORDE model to simulate synthetic data.
}
\details{
\code{forge} simulates a synthetic dataset of \code{n_synth} samples. First,
leaves are sampled in proportion to either their coverage (if
\code{evidence = NULL}) or their posterior probability. Then, each feature is
sampled independently within each leaf according to the probability mass or
density function learned by \code{\link{forde}}. This will create realistic
data so long as the adversarial RF used in the previous step satisfies the
local independence criterion. See Watson et al. (2023).

There are three methods for (optionally) encoding conditioning events via the
\code{evidence} argument. The first is to provide a partial sample, where
some but not all columns from the training data are present. The second is to
provide a data frame with three columns: \code{variable}, \code{relation},
and \code{value}. This supports inequalities via \code{relation}.
Alternatively, users may directly input a pre-calculated posterior
distribution over leaves, with columns \code{f_idx} and \code{wt}. This may
be preferable for complex constraints. See Examples.
}
\examples{
arf <- adversarial_rf(iris)
psi <- forde(arf, iris)
x_synth <- forge(psi, n_synth = 100)

# Condition on Species = "setosa"
evi <- data.frame(Species = "setosa")
x_synth <- forge(psi, n_synth = 100, evidence = evi)

# Condition in Species = "setosa" and Sepal.Length > 6
evi <- data.frame(variable = c("Species", "Sepal.Length"),
                  relation = c("==", ">"), 
                  value = c("setosa", 6))
x_synth <- forge(psi, n_synth = 100, evidence = evi)

# Or just input some distribution on leaves
# (Weights that do not sum to unity are automatically scaled)
n_leaves <- nrow(psi$forest)
evi <- data.frame(f_idx = psi$forest$f_idx, wt = rexp(n_leaves))
x_synth <- forge(psi, n_synth = 100, evidence = evi)


}
\references{
Watson, D., Blesch, K., Kapar, J., & Wright, M. (2023). Adversarial random
forests for density estimation and generative modeling. In \emph{Proceedings
of the 26th International Conference on Artificial Intelligence and
Statistics}, pp. 5357-5375.
}
\seealso{
\code{\link{adversarial_rf}}, \code{\link{forde}}
}
