% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.predARFIMA.R
\name{plot.predarfima}
\alias{plot.predarfima}
\title{Plots the original time series, the predictions, and the prediction
intervals for a \code{predarfima} object.}
\usage{
\method{plot}{predarfima}(
  x,
  xlab = NULL,
  ylab = NULL,
  main = NULL,
  ylim = NULL,
  numback = 5,
  xlim = NULL,
  ...
)
}
\arguments{
\item{x}{A \code{predarfima} object}

\item{xlab}{Optional}

\item{ylab}{Optional}

\item{main}{Optional}

\item{ylim}{Optional}

\item{numback}{The number of last values of the original series to plot
defined by the user. The default is five}

\item{xlim}{Optional}

\item{\dots}{Currently not used}
}
\value{
None. Generates a plot
}
\description{
This function takes a \code{predarfima} object generated by
\code{predict.arfima} and plots all of the information contained in it.  The
colour code is as follows:
}
\details{
grey: exact prediction
red: exact prediction intervals (PIs)
orange: limiting PIs

See \code{\link{predict.arfima}}.
}
\examples{
\donttest{
set.seed(82365)
sim <- arfima.sim(1000, model = list(dfrac = 0.4, theta=0.9, dint = 1))
fit <- arfima(sim, order = c(0, 1, 1), back=TRUE)
fit
pred <- predict(fit, n.ahead = 5)
pred
plot(pred)
#Let's look at more context
plot(pred, numback = 50)
}
}
\references{
Veenstra, J.Q. Persistence and Antipersistence:  Theory and
Software (PhD Thesis)
}
\seealso{
\code{\link{predict.arfima}}, \code{\link{print.predarfima}}
}
\author{
JQ (Justin) Veenstra
}
\keyword{ts}
