% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rmd_to_ari.R
\name{rmd_to_ari}
\alias{rmd_to_ari}
\title{Convert a Rmd to an Ari Document}
\usage{
rmd_to_ari(
  path,
  script = NULL,
  capture_method = c("iterative", "vectorized"),
  capturer = c("chrome_print", "webshot"),
  capturer_args = list(),
  ...,
  rendered_file = NULL,
  verbose = TRUE
)
}
\arguments{
\item{path}{path to Rmd file}

\item{script}{optional spoken script, otherwise taken from the
HTML comments}

\item{capture_method}{Either \code{"vectorized"} or \code{"iterative"}. The
vectorized mode is faster though it can cause screens to repeat.
If making a video from an \link[rmarkdown:ioslides_presentation]{rmarkdown::ioslides_presentation}
you should use \code{"iterative"}.}

\item{capturer}{Methods for capturing the HTML slides}

\item{capturer_args}{a list of arguments to pass to \link[webshot:webshot]{webshot::webshot} or
\link[pagedown:chrome_print]{pagedown::chrome_print}}

\item{...}{additional arguments to pass to \link{make_ari_document}}

\item{rendered_file}{the HTML output already from \link{render}}

\item{verbose}{print diagnostic messages}
}
\value{
The output of \link{make_ari_document}
}
\description{
Convert a Rmd to an Ari Document
}
\examples{
\donttest{
path = system.file("extdata", "example.Rmd", package = "ariExtra")
res = rmd_to_ari(path, open = FALSE)
res$output_file
}

\donttest{
# xaringan example
have_decktape = nzchar(Sys.which("decktape"))
if (have_decktape) {
  if (requireNamespace("xaringan", quietly = TRUE)) {
    path  = system.file("examples", "lucy-demo.Rmd", package = "xaringan")
    x = readLines(path)
    x = gsub("library\\\\(ggplot2\\\\)", "", x)
    x = gsub("^\\\\s*ggplot.*", "", x)
    x = gsub("^\\\\s*geom_bar.*", "barplot(table(mtcars$am))", x)
    path = tempfile(fileext = ".Rmd")
    writeLines(x, path)
    script = c("this", "is", "one", "word", "per slide")
    rendered_file = tempfile(fileext = ".html")

    rmarkdown::render(path, output_format = xaringan::moon_reader(),
                      output_file = rendered_file)


    pdf_file = tempfile(fileext = ".pdf")
    xaringan::decktape(rendered_file, pdf_file, docker = FALSE)

    res = pdf_to_ari(pdf_file, script = script, open = FALSE)
  }
}
}
}
