% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/reshape.R
\docType{methods}
\name{reshape}
\alias{reshape}
\alias{to_long}
\alias{to_long-method}
\alias{to_long,matrix-method}
\title{Reshape}
\usage{
to_long(from, ...)

\S4method{to_long}{matrix}(from, factor = FALSE, reverse = FALSE)
}
\arguments{
\item{from}{An object to be coerced.}

\item{...}{Currently not used.}

\item{factor}{A \code{\link{logical}} scalar: should character string be
coerced to \code{\link{factor}}? Default to \code{FALSE}, if \code{TRUE} the original ordering is
preserved.}

\item{reverse}{A \code{\link{logical}} scalar: should the order of factor levels be
reversed? Only used if \code{factor} is \code{TRUE}. Useful for plotting.}
}
\value{
A coerced object.
}
\description{
Transforms a \code{matrix} to a long \code{data.frame}.
}
\examples{
## Create a matrix
A <- matrix(data = sample(0:10, 100, TRUE), nrow = 20, ncol = 5)

## Transform to long data.frame
head(to_long(A))
}
\seealso{
Other transformation tools: 
\code{\link{append}()},
\code{\link{assign}()}
}
\author{
N. Frerebeau
}
\concept{transformation tools}
