% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assert.R
\name{assert_package}
\alias{assert_package}
\alias{needs}
\title{Check the Availability of a Package}
\usage{
assert_package(x, ask = TRUE)

needs(x, ask = TRUE)
}
\arguments{
\item{x}{A \code{\link{character}} vector naming the packages to check.}

\item{ask}{A \code{\link{logical}} scalar: should the user be asked to select packages
before they are downloaded and installed?}
}
\value{
Invisibly returns \code{NULL}.
}
\description{
Check the Availability of a Package
}
\details{
\code{assert_package()} is designed for use inside other functions in your own
package to check for the availability of a suggested package.

If the required packages are not available and \R is running interactively,
the user will be asked to install the packages.

\code{needs()} is an alias for \code{assert_package()}.
}
\seealso{
Other checking methods: 
\code{\link{assert_constant}()},
\code{\link{assert_dim}()},
\code{\link{assert_empty}()},
\code{\link{assert_infinite}()},
\code{\link{assert_length}()},
\code{\link{assert_lower}()},
\code{\link{assert_missing}()},
\code{\link{assert_names}()},
\code{\link{assert_numeric}},
\code{\link{assert_square}()},
\code{\link{assert_type}()},
\code{\link{assert_unique}()}
}
\author{
N. Frerebeau
}
\concept{checking methods}
