% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/csv.R, R/json.R
\name{csv_table_reader}
\alias{csv_table_reader}
\alias{json_table_reader}
\title{Arrow CSV and JSON table readers}
\usage{
csv_table_reader(file, read_options = csv_read_options(),
  parse_options = csv_parse_options(),
  convert_options = csv_convert_options(), ...)

json_table_reader(file, read_options = json_read_options(),
  parse_options = json_parse_options(), ...)
}
\arguments{
\item{file}{A character path to a local file, or an Arrow input stream}

\item{read_options}{see \code{\link[=csv_read_options]{csv_read_options()}}}

\item{parse_options}{see \code{\link[=csv_parse_options]{csv_parse_options()}}}

\item{convert_options}{see \code{\link[=csv_convert_options]{csv_convert_options()}}}

\item{...}{additional parameters.}
}
\value{
An \code{arrow::csv::TableReader} or \code{arrow::json::TableReader} R6
object. Call \code{$Read()} on it to get an Arrow Table.
}
\description{
These methods wrap the Arrow C++ CSV and JSON table readers.
For an interface to the CSV reader that's more familiar for R users, see
\code{\link[=read_csv_arrow]{read_csv_arrow()}}
}
