% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/labels.R
\name{labels}
\alias{labels}
\alias{labels.data.frame}
\alias{labels.keep_labels}
\alias{labels<-}
\alias{set_labels}
\alias{labels<-.keep_labels}
\alias{labels<-.data.frame}
\title{Labels}
\usage{
\method{labels}{data.frame}(object, ...)

\method{labels}{keep_labels}(object, ...)

labels(x) <- value

set_labels(x, value)

\method{labels}{keep_labels}(x) <- value

\method{labels}{data.frame}(x) <- value
}
\arguments{
\item{...}{Other arguments (not in use at this time).}

\item{x, object}{An R object.}

\item{value}{A vector or list containing labels to assign. Labels are assigned based on
names, if available; otherwise, they're assigned in order. Can pass \code{NULL}
to remove all labels.}
}
\value{
The labels of \code{object}, or \code{object} with new labels.
}
\description{
Assign and extract the \code{'label'} attribute on an R object. \code{set_labels} is
  does the same as \code{labels(x) <- value} but returns \code{x} for use in a pipe chain.
}
\details{
The \code{\link{data.frame}} methods put labels on and extract labels from
  the \emph{columns} of \code{object}.
}
\author{
Ethan Heinzen
}
