% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lik.R
\name{logF_lik}
\alias{logF_lik}
\title{Likelihood object for logF error distribution}
\usage{
logF_lik(df1, df2)
}
\arguments{
\item{df1}{first degree of freedom parameter of F distribution}

\item{df2}{second degree of freedom parameter of F distribution}
}
\description{
Creates a likelihood object for ash for use with logF error distribution
}
\examples{
   e = rnorm(100) + log(rf(100,df1=10,df2=10)) # simulate some data with log(F) error
   ash(e,1,lik=logF_lik(df1=10,df2=10))
}

