% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bandsolve.R
\name{mat2rot}
\alias{mat2rot}
\title{Rotate a band matrix to get the rotated row-wised matrix associated.}
\usage{
mat2rot(M)
}
\arguments{
\item{M}{Band square matrix or a list of diagonal.}
}
\value{
Rotated matrix.
}
\description{
Rotate a symmetric band matrix to get the rotated matrix associated.
Each column of the rotated matrix correspond to a diagonal. The first column is the main diagonal, the second one is the upper-diagonal and so on.
Artificial 0 are placed at the end of each column if necessary.
}
\examples{

A = diag(4)
A[2,3] = 2
A[3,2] = 2

## Original Matrix
A
## Rotated version
R = mat2rot(A)
R

rot2mat(mat2rot(A))
}
