% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assert-is-code.R, R/is-code.R
\name{assert_is_binding_locked}
\alias{assert_is_binding_locked}
\alias{is_binding_locked}
\title{Is the binding of a variable locked?}
\usage{
assert_is_binding_locked(x, severity = getOption("assertive.severity",
  "stop"))

is_binding_locked(x, env = if (is_scalar(e <- find(.xname)))
  as.environment(e) else parent.frame(), .xname = get_name_in_parent(x))
}
\arguments{
\item{x}{Input to check. (Unlike \code{bindingIsLocked}, you can pass the
variable itself, rather than a string naming that variable.)}

\item{severity}{How severe should the consequences of the assertion be?
Either \code{"stop"}, \code{"warning"}, \code{"message"}, or \code{"none"}.}

\item{env}{Environment to check where binding had been locked.}

\item{.xname}{Not intended to be used directly.}
}
\value{
\code{TRUE} or \code{FALSE}, depending upon whether or not the 
binding is locked in the specified environment.
\code{assert_is_binding_locked} returns nothing but throws an error if 
the corresponding \code{is_*} function returns \code{FALSE}.
}
\description{
Check to see if the binding of a variable is locked (that is, it has been 
made read-only).
}
\note{
The environment is guessed as follows: The name of \code{x} is 
determined via \code{get_name_in_parent}.  Then find is called,
}
\examples{
is_binding_locked(a_non_existent_variable)
e <- new.env()
e$x <- 1:10
is_binding_locked(x, e)
lockBinding("x", e)
is_binding_locked(x, e)
unlockBinding("x", e)
is_binding_locked(x, e)
}
\seealso{
\code{\link[base]{bindingIsLocked}}, which this wraps, 
\code{\link[utils]{find}} for how the environment is guessed.  If this returns
a single environment, that is used.  Otherwise the parent environment is 
used (as determined with \code{\link[base]{parent.frame}}).
}
