% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assert-is-type-base.R, R/assert-is-type-stats.R, R/is-type-base.R, R/is-type-stats.R
\name{assert_is_function}
\alias{assert_is_function}
\alias{assert_is_primitive}
\alias{assert_is_stepfun}
\alias{is_function}
\alias{is_primitive}
\alias{is_stepfun}
\title{Is the input a function?}
\usage{
assert_is_function(x, severity = getOption("assertive.severity", "stop"))

assert_is_primitive(x, severity = getOption("assertive.severity", "stop"))

assert_is_stepfun(x, severity = getOption("assertive.severity", "stop"))

is_function(x, .xname = get_name_in_parent(x))

is_primitive(x, .xname = get_name_in_parent(x))

is_stepfun(x, .xname = get_name_in_parent(x))
}
\arguments{
\item{x}{Input to check.}

\item{severity}{How severe should the consequences of the assertion be?
Either \code{"stop"}, \code{"warning"}, \code{"message"}, or \code{"none"}.}

\item{.xname}{Not intended to be used directly.}
}
\value{
\code{is_function}, \code{is_primitive} and \code{is_stepfun}
wrap \code{is.function}, \code{is.primitive} and \code{is.stepfun} 
repsectively, providing more information on failure.  The 
\code{assert_*} functions return nothing but throw an error if the
corresponding \code{is_*} function returns \code{FALSE}.
}
\description{
Checks to see if the input is a function.
}
\examples{
assert_is_function(sqrt)
assert_is_function(function(){})
}
\seealso{
\code{\link[base]{is.function}}.
}

