% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assertions.R
\name{verify}
\alias{verify}
\title{Raises error if expression is FALSE anywhere}
\usage{
verify(data, expr, success_fun = success_continue, error_fun = error_stop)
}
\arguments{
\item{data}{A data frame, list, or environment}

\item{expr}{A logical expression}

\item{success_fun}{Function to call if assertion passes. Defaults to
returning \code{data}.}

\item{error_fun}{Function to call if assertion fails. Defaults to printing
a summary of all errors.}
}
\value{
By default, the \code{data} is returned if predicate assertion
        is TRUE and and error is thrown if not. If a non-default
        \code{success_fun} or \code{error_fun} is used, the return
        values of these function will be returned.
}
\description{
Meant for use in a data analysis pipeline, this function will
just return the data it's supplied if all the logicals in the
expression supplied are TRUE. If at least one is FALSE, this
function will raise a error, effectively terminating the pipeline
early
}
\details{
For examples of possible choices for the \code{success_fun} and
\code{error_fun} parameters, run \code{help("success_and_error_functions")}
}
\note{
See \code{vignette("assertr")} for how to use this in context
}
\examples{

verify(mtcars, drat > 2)     # returns mtcars
\dontrun{
verify(mtcars, drat > 3)     # produces error}


library(magrittr)            # for piping operator

\dontrun{
mtcars \%>\%
  verify(drat > 3) \%>\%
  # anything here will not run}

mtcars \%>\%
  verify(nrow(mtcars) > 2)
  # anything here will run

alist <- list(a=c(1,2,3), b=c(4,5,6))
verify(alist, length(a) > 2)
verify(alist, length(a) > 2 && length(b) > 2)
verify(alist, a > 0 & b > 2)

\dontrun{
alist \%>\%
  verify(alist, length(a) > 5)
  # nothing here will run}


}
\seealso{
\code{\link{assert}} \code{\link{insist}}
}
