% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagnostic_plots.R
\name{plot_res_vs_linear_predictor}
\alias{plot_res_vs_linear_predictor}
\title{Plot Residuals against Linear Predictor}
\usage{
plot_res_vs_linear_predictor(
  model,
  residual_fn = stats::rstandard,
  xlab = "Linear Predictor",
  ylab = "Standardized deviance residuals",
  ...
)
}
\arguments{
\item{model}{Model with methods \code{\link[=predict]{predict()}} or \code{\link[=fitted]{fitted()}}}

\item{residual_fn}{A function to calculate model residuals. The default is
\code{stats::rstandard}.}

\item{xlab}{The label for the x-axis. Defaults to "Linear Predictor".}

\item{ylab}{The label for the y-axis. Defaults to "Standardized deviance residuals".}

\item{...}{Extra arguments to \code{residual_fn} and \code{\link[=plot]{plot()}}.}
}
\value{
An invisible list containing the linear predictor (x) and standardized
deviance residuals (y).
}
\description{
Plot Residuals against Linear Predictor
}
\details{
If the model was fitted using the \code{\link[=glm]{glm()}} function, it will use the \code{\link[=predict]{predict()}}
method with \code{type = link}, otherwise, it will use the \code{\link[=fitted]{fitted()}} method.
}
\examples{
fit <- lm(mpg ~ cyl, data = mtcars)

plot_res_vs_linear_predictor(fit)
plot_res_vs_linear_predictor(fit, residual_fn = rstudent)
plot_res_vs_linear_predictor(fit, residual_fn = residuals)


glm_fit <- glm(cyl ~ mpg, family = poisson(), data = mtcars)

plot_res_vs_linear_predictor(glm_fit)
plot_res_vs_linear_predictor(glm_fit, type = "pearson")

}
