% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_VaR.R
\name{f_VaR}
\alias{f_VaR}
\title{Value-at-Risk}
\usage{
f_VaR(alpha, type_function, params)
}
\arguments{
\item{alpha}{Numeric argument for Expected-Shortfall, between 0 and 1}

\item{type_function}{String argument : "gaussian" for normal distribution or "skew-t" for t-student distribution}

\item{params}{Numeric vector containing parameters of the distribution}
}
\value{
Numeric value for the Value-at-Risk given the distribution and the alpha risk
}
\description{
The function allows to calculate Value-at-Risk for a given distribution. It takes as parameters alpha (risk level), a distribution and the parameters associated with this distribution. For example, for a normal distribution, the user must enter the mean and the standard deviation. Currently, the function can calculate the Value-at-Risk for the normal distribution and for the skew-t distribution (Azzalini and Capitianio, 2003)
}
\examples{
f_VaR(0.95, "gaussian", params=c(0,1))

}
\references{
Azzalini, Adelchi, and Antonella Capitanio. "Distributions generated by perturbation of symmetry with emphasis on a multivariate skew t‐distribution." Journal of the Royal Statistical Society: Series B (Statistical Methodology) 65.2 (2003): 367-389.

Azzalini, Adelchi, and Maintainer Adelchi Azzalini. "Package ‘sn’." The skew-normal and skew-t distributions (2015): 1-3.
}
