% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate-consumed-biomass.R
\name{calculate_consumed_biomass}
\alias{calculate_consumed_biomass}
\title{Calculate the consumed biomass in [t] of prey j by predator i.}
\usage{
calculate_consumed_biomass(eat, grazing, dm, vol, bio_conv)
}
\arguments{
\item{eat}{Dataframe with information about consumption for age-based groups.
Should be generated with \code{\link{load_nc}}.}

\item{grazing}{Dataframe with information about consumption for non-age-based groups.
Should be generated with \code{\link{load_nc}}.}

\item{dm}{Dataframe with information about diet contributions per predator.
Should be generated with \code{\link{load_dietcheck}} using \code{convert_names = TRUE}.}

\item{vol}{Dataframe with information about volume per polygon and layer.
Should be generated with \code{\link{load_nc_physics}}.}

\item{bio_conv}{Numeric value to transform weight in mg N to tonnes.
Should be generated with \code{\link{get_conv_mgnbiot}}.}
}
\value{
Dataframe with columns 'pred', 'agecl', 'polygon', 'time', 'prey'.
Consumed biomass in [t] is stored in column 'atoutput'.
}
\description{
Consumption data is extracted from output[...]PROD.nc. Age based groups
are stored as "Eat_" non age based groups as "Grazing_". Units are mg N m^-3 d^-1.
Factors are species, time, box and agecl (if present). We will refer to species as
pred from here on to indicate the predator perspective.
Diet constribution data is extracted from DietCheck.txt. Currently this only works
for models based on the trunk code. Units are % diet contribution. Factors are pred, time, agecl, prey.
The consumed biomass is calculated as follows:
- Calculate consumed biomass as Eat (or Grazing) * boxvolume per time, pred, agecl, box.
- Convert to biomass in [t].
- Combine with diet contributions and calculate consumed biomass of prey species.
}
\examples{
# 1. Using built-in datasets.
d <- system.file("extdata", "setas-model-new-trunk", package = "atlantistools")
prm_biol <- file.path(d, "VMPA_setas_biol_fishing_Trunk.prm")

bio_conv <- get_conv_mgnbiot(prm_biol = prm_biol)

df <- calculate_consumed_biomass(eat = ref_eat, grazing = ref_grazing, dm = ref_dm,
                                 vol = ref_vol, bio_conv = bio_conv)

# 2. Read in dataframes from existing Atlantis simulation.
bboxes <- get_boundary(boxinfo = load_box(file.path(d, "VMPA_setas.bgm")))
nc_gen <- file.path(d, "outputSETAS.nc")
nc_prod <- file.path(d, "outputSETASPROD.nc")
prm_run <- file.path(d, "VMPA_setas_run_fishing_F_Trunk.prm")
fgs <- file.path(d, "SETasGroupsDem_NoCep.csv")
init <- file.path(d, "INIT_VMPA_Jan2015.nc")

bps <- load_bps(fgs = fgs, init = init)

groups_age <- c("Planktiv_S_Fish", "Pisciv_S_Fish")
groups_rest <- c("Cephalopod", "Megazoobenthos", "Diatom", "Lab_Det", "Ref_Det")

df_eat <- load_nc(nc = nc_prod, bps = bps, fgs = fgs,
               select_groups = groups_age, select_variable = "Eat",
               prm_run = prm_run, bboxes = bboxes)
df_grz <- load_nc(nc = nc_prod, bps = bps, fgs = fgs,
               select_groups = groups_rest, select_variable = "Grazing",
               prm_run = prm_run, bboxes = bboxes)
df_dm <- load_dietcheck(dietcheck = file.path(d, "outputSETASDietCheck.txt"),
                        fgs = fgs, prm_run = prm_run, version_flag = 2, convert_names = TRUE)
vol <- load_nc_physics(nc = nc_gen, select_physics = "volume",
                       prm_run = prm_run, bboxes = bboxes, aggregate_layers = FALSE)

df <- calculate_consumed_biomass(eat = df_eat, grazing = df_grz, dm = df_dm,
                                 vol = vol, bio_conv = bio_conv)
}
