% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_remotes.R
\name{find_remotes}
\alias{find_remotes}
\title{Proposes values for Remotes field for DESCRIPTION file based on your installation}
\usage{
find_remotes(pkg)
}
\arguments{
\item{pkg}{Character. Packages to test for potential non-CRAN installation}
}
\value{
List of non-CRAN packages and code to add in Remotes field in DESCRIPTION
}
\description{
Proposes values for Remotes field for DESCRIPTION file based on your installation
}
\examples{
# Find from vector of packages
find_remotes(pkg = c("attachment", "desc", "glue"))
# Find from Description file
dummypackage <- system.file("dummypackage", package = "attachment")
att_from_description(
path = file.path(dummypackage, "DESCRIPTION")) \%>\%
find_remotes()
\dontrun{
# For your current directory
att_from_description() \%>\% find_remotes()
# Find from all installed packages
head(find_remotes(installed.packages()[,1]))
}
}
