\name{plotAll}
\alias{plotAll}

\title{  Plot comparison for all available statistics.}

\description{
  This function is a wrapper around plotComparison to facilitate the simultaneous generation of all available plots. They may also be redirected to 'png' or 'pdf' files.
}

\usage{plotAll(results.1, results.2, name.1, name.2, type = "both", outdir = "./", format = "")}

\arguments{
  \item{results.1}{
  A list of statistics generated by the function 'expressionStats'.
}
  \item{results.2}{
  A list of statistics generated by the function 'expressionStats'.
}
  \item{name.1}{
  The name of the first dataset represented by 'results.1'.
}
  \item{name.2}{
  The name of the second dataset represented by 'results.2'.
}
  \item{type}{
  Specifies whether histograms, qq-plots or both should be plotted. Must be on of 'both', 'hist', 'qq'. Defaults to 'both'.
}
  \item{outdir}{
  Specifies a directory where the resulting plots should be saved. Only used if format is 'png' or 'pdf'. Defaults to the current working directory.
}
  \item{format}{
  Specifies whether plots should be redirected to files. Can be 'png' or 'pdf'.
}
}


\author{
Robert Maier
}

\seealso{
\code{plotComparison}
\code{getAllScores}
\code{expressionStats}
}

\examples{
data(GNW.s.expression.data)
data(GNW.s.network)
data(GNW.s.exp.group)
results <- expressionStats(GNW.s.expression.data, GNW.s.network, GNW.s.exp.group)
results.p <- expressionStats(GNW.s.expression.data, GNW.s.network, GNW.s.exp.group, permute.genes=TRUE)
plotAll(results, results.p, 'n.normal', 'n.permuted', type='both')
}
