% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotD3_prediction.R
\name{plotD3_prediction}
\alias{plotD3_prediction}
\alias{plotD3Prediction}
\title{Plot Prediction vs Target, Observed or Variable Values in D3 with r2d3 package.}
\usage{
plotD3_prediction(object, ..., variable = "_y_", points = TRUE,
  smooth = FALSE, abline = FALSE, point_count = NULL,
  single_plot = TRUE, scale_plot = FALSE, background = FALSE)

plotD3Prediction(object, ..., variable = NULL, points = TRUE,
  smooth = FALSE, abline = FALSE, point_count = NULL,
  single_plot = TRUE, scale_plot = FALSE, background = FALSE)
}
\arguments{
\item{object}{An object of class 'auditor_model_residual.}

\item{...}{Other modelAudit or modelResiduals objects to be plotted together.}

\item{variable}{Name of variable to order residuals on a plot.
If \code{variable="_y_"}, the data is ordered by a vector of actual response (\code{y} parameter
passed to the \code{\link[DALEX]{explain}} function).
If \code{variable = "_y_hat_"} the data on the plot will be ordered by predicted response.
If \code{variable = NULL}, unordered observations are presented.}

\item{points}{Logical, indicates whenever observations should be added as points. By defaul it's TRUE.}

\item{smooth}{Logical, indicates whenever smoothed lines should be added. By default it's FALSE.}

\item{abline}{Logical, indicates whenever function y = x should be added. Works only
with \code{variable = NULL} which is a default option.}

\item{point_count}{Number of points to be plotted per model. Points will be chosen randomly. By default plot all of them.}

\item{single_plot}{Logical, indicates whenever single or facets should be plotted. By default it's TRUE.}

\item{scale_plot}{Logical, indicates whenever the plot should scale with height. By default it's FALSE.}

\item{background}{Logical, available only if single_plot = FALSE. Indicates whenever backgroud plots should be plotted.
By default it's FALSE.}
}
\value{
a `r2d3` object.
}
\description{
Function \code{plotD3_prediction} plots predicted values observed or variable values in the model.
}
\examples{

dragons <- DALEX::dragons[1:100, ]

# fit a model
model_lm <- lm(life_length ~ ., data = dragons)

# use DALEX package to wrap up a model into explainer
exp_lm <- DALEX::explain(model_lm, data = dragons, y = dragons$life_length)

# validate a model with auditor
library(auditor)
mr_lm <- model_residual(exp_lm)

# plot results
plotD3_prediction(mr_lm, abline = TRUE)
plotD3_prediction(mr_lm, variable = "height", smooth = TRUE)

library(randomForest)
model_rf <- randomForest(life_length~., data = dragons)
exp_rf <- DALEX::explain(model_rf, data = dragons, y = dragons$life_length)
mr_rf <- model_residual(exp_rf)
plotD3_prediction(mr_lm, mr_rf, variable = "weight", smooth = TRUE)

}
\seealso{
\code{\link{plot_prediction}}
}
