% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.R
\name{print.auditor_model_residual}
\alias{print.auditor_model_residual}
\title{Prints Model Residual Summary}
\usage{
\method{print}{auditor_model_residual}(x, ...)
}
\arguments{
\item{x}{an object 'auditor_model_residual' created with \code{\link{model_residual}} function.}

\item{...}{other parameters}
}
\description{
Prints Model Residual Summary
}
\examples{
titanic <- na.omit(DALEX::titanic)

# fit a model
model_glm <- glm(survived ~ ., family = binomial, data = titanic)
titanic$survived <- titanic$survived == "yes"

# use DALEX package to wrap up a model into explainer
exp_glm <- DALEX::explain(model_glm, data = titanic, y = titanic$survived)

# validate a model with auditor
library(auditor)
model_residual(exp_glm)

}
