% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auk-time.r
\name{auk_time}
\alias{auk_time}
\title{Filter the eBird data by checklist start time}
\usage{
auk_time(x, start_time)
}
\arguments{
\item{x}{\code{auk_ebd} or \code{auk_sampling} object; reference to file created by
\code{\link[=auk_ebd]{auk_ebd()}} or \code{\link[=auk_sampling]{auk_sampling()}}.}

\item{start_time}{character; 2 element character vector giving the range of
times in 24 hour format, e.g. \code{"06:30"} or \code{"16:22"}.}
}
\value{
An \code{auk_ebd} object.
}
\description{
Define a filter for the eBird Basic Dataset (EBD) based on a range of start
times for the checklist. This function only defines the filter and, once all
filters have been defined, \code{\link[=auk_filter]{auk_filter()}} should be used to call AWK and
perform the filtering.
}
\details{
This function can also work with on an \code{auk_sampling} object if the
user only wishes to filter the sampling event data.
}
\examples{
# only keep checklists started between 6 and 8 in the morning
system.file("extdata/ebd-sample.txt", package = "auk") \%>\%
  auk_ebd() \%>\%
  auk_time(start_time = c("06:00", "08:00"))
  
# alternatively, without pipes
ebd <- auk_ebd(system.file("extdata/ebd-sample.txt", package = "auk"))
auk_time(ebd, start_time = c("06:00", "08:00"))
}
\seealso{
Other filter: \code{\link{auk_breeding}},
  \code{\link{auk_complete}}, \code{\link{auk_country}},
  \code{\link{auk_date}}, \code{\link{auk_distance}},
  \code{\link{auk_duration}}, \code{\link{auk_extent}},
  \code{\link{auk_filter}}, \code{\link{auk_last_edited}},
  \code{\link{auk_project}}, \code{\link{auk_protocol}},
  \code{\link{auk_species}}, \code{\link{auk_state}}
}
\concept{filter}
