% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kcca.R
\name{pfa.kcca}
\alias{pfa.kcca}
\title{PFA Formatting of Fitted K-Centroid Models}
\source{
pfa_config.R avro_typemap.R avro.R pfa_cellpool.R pfa_expr.R pfa_utils.R
}
\usage{
\method{pfa}{kcca}(object, name = NULL, version = NULL, doc = NULL,
  metadata = NULL, randseed = NULL, options = NULL,
  cluster_names = NULL, ...)
}
\arguments{
\item{object}{an object of class "kcca"}

\item{name}{a character which is an optional name for the scoring engine}

\item{version}{an integer which is sequential version number for the model}

\item{doc}{a character which is documentation string for archival purposes}

\item{metadata}{a \code{list} of strings that is computer-readable documentation for 
archival purposes}

\item{randseed}{a integer which is a global seed used to generate all random 
numbers. Multiple scoring engines derived from the same PFA file have 
different seeds generated from the global one}

\item{options}{a \code{list} with value types depending on option name 
Initialization or runtime options to customize implementation 
(e.g. optimization switches). May be overridden or ignored by PFA consumer}

\item{cluster_names}{a character vector of length k to name the values relating
to each cluster instead of just an integer. If not specified, then the predicted 
cluster will be the string representation of the cluster index.}

\item{...}{additional arguments affecting the PFA produced}
}
\value{
a \code{list} of lists that compose valid PFA document
}
\description{
This function takes a K-centroids model fit using kcca  
and returns a list-of-lists representing in valid PFA document 
that could be used for scoring
}
\examples{
model <- flexclust::kcca(iris[,1:4], k = 3, family=flexclust::kccaFamily("kmeans"))
model_as_pfa <- pfa(model)
}
\seealso{
\code{\link[flexclust]{kcca}} \code{\link{extract_params.kcca}}
}
