% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parse_authors_r.R
\name{parse_authors_r}
\alias{parse_authors_r}
\title{Parse the \code{Authors@R} field from a DESCRIPTION file}
\usage{
parse_authors_r(authors_r_string)
}
\arguments{
\item{authors_r_string}{A character containing the \code{Authors@R} field from a
\code{DESCRIPTION} file}
}
\value{
A \code{person} object, or a \code{list} of \code{person} objects of length equals
to the length of \code{authors_r_string}
}
\description{
Parse the \code{Authors@R} field from a DESCRIPTION file into a \code{person} object
}
\examples{
# Read from a DESCRIPTION file directly
pkg_description <- system.file("DESCRIPTION", package = "authoritative")
authors_r_pkg <- read.dcf(pkg_description, "Authors@R")

parse_authors_r(authors_r_pkg)

# Read from a database of CRAN metadata
cran_epidemiology_packages |>
  subset(!is.na(`Authors@R`), `Authors@R`, drop = TRUE) |>
  parse_authors_r() |>
  head()

}
